/*
 * Decompiled with CFR 0.152.
 */
package datadog.environment;

import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class EnvironmentVariables {
    public static EnvironmentVariablesProvider provider = new EnvironmentVariablesProvider();

    private EnvironmentVariables() {
    }

    @Nullable
    public static String get(String name) {
        return EnvironmentVariables.getOrDefault(name, null);
    }

    public static String getOrDefault(String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        try {
            String value = provider.get(name);
            return value == null ? defaultValue : value;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    public static Map<String, String> getAll() {
        try {
            return Collections.unmodifiableMap(new HashMap<String, String>(provider.getAll()));
        }
        catch (SecurityException e) {
            return Collections.emptyMap();
        }
    }

    public static class EnvironmentVariablesProvider {
        @SuppressForbidden
        public String get(String name) {
            return System.getenv(name);
        }

        @SuppressForbidden
        public Map<String, String> getAll() {
            return System.getenv();
        }
    }
}

