/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.directallocation;

import datadog.trace.api.Config;
import datadog.trace.api.sampling.PerRecordingRateLimiter;
import datadog.trace.bootstrap.instrumentation.jfr.WindowSampler;
import datadog.trace.bootstrap.instrumentation.jfr.directallocation.DirectAllocationSampleEvent;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class DirectAllocationSampler
extends WindowSampler<DirectAllocationSampleEvent> {
    private static final Duration SAMPLING_WINDOW = Duration.of(500L, ChronoUnit.MILLIS);

    protected DirectAllocationSampler(Config conf) {
        super(SAMPLING_WINDOW, DirectAllocationSampler.getSamplesPerWindow(conf), PerRecordingRateLimiter.samplingWindowsPerRecording(conf.getProfilingUploadPeriod(), SAMPLING_WINDOW), DirectAllocationSampleEvent.class);
    }

    protected static int getSamplesPerWindow(Config config) {
        return config.getProfilingDirectAllocationSampleLimit() / PerRecordingRateLimiter.samplingWindowsPerRecording(config.getProfilingUploadPeriod(), SAMPLING_WINDOW);
    }
}

