/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.telemetry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface MetricCollector<M extends Metric> {
    public static final int RAW_QUEUE_SIZE = 1024;

    public void prepareMetrics();

    public Collection<M> drain();

    default public Collection<DistributionSeriesPoint> drainDistributionSeries() {
        return Collections.emptySet();
    }

    public static class DistributionSeriesPoint {
        public final String metricName;
        public final boolean common;
        public final String namespace;
        public final int value;
        public final List<String> tags;

        public DistributionSeriesPoint(String metricName, boolean common, String namespace, int value, List<String> tags) {
            this.metricName = metricName;
            this.common = common;
            this.namespace = namespace;
            this.value = value;
            this.tags = tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistributionSeriesPoint that = (DistributionSeriesPoint)o;
            return this.common == that.common && Objects.equals(this.metricName, that.metricName) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.tags, that.tags);
        }

        public int hashCode() {
            return Objects.hash(this.metricName, this.common, this.namespace, this.tags);
        }

        public String toString() {
            return "DistributionSeriesPoint{metricName='" + this.metricName + '\'' + ", common=" + this.common + ", namespace='" + this.namespace + '\'' + ", value=" + this.value + ", tags=" + this.tags + '}';
        }
    }

    public static class Metric {
        public final String metricName;
        public final boolean common;
        public final String namespace;
        public final String type;
        public final long timestamp;
        public final Number value;
        public final List<String> tags;

        public Metric(String namespace, boolean common, String metricName, String type, Number value, String tag) {
            this(namespace, common, metricName, type, value, tag == null ? Collections.emptyList() : Collections.singletonList(tag));
        }

        public Metric(String namespace, boolean common, String metricName, String type, Number value, String ... tags) {
            this(namespace, common, metricName, type, value, Arrays.asList(tags));
        }

        public Metric(String namespace, boolean common, String metricName, String type, Number value, List<String> tags) {
            this.namespace = namespace;
            this.common = common;
            this.metricName = metricName;
            this.type = type;
            this.timestamp = System.currentTimeMillis() / 1000L;
            this.value = value;
            this.tags = tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric metric = (Metric)o;
            return this.common == metric.common && Objects.equals(this.metricName, metric.metricName) && Objects.equals(this.namespace, metric.namespace) && Objects.equals(this.tags, metric.tags);
        }

        public int hashCode() {
            return Objects.hash(this.metricName, this.common, this.namespace, this.tags);
        }

        public String toString() {
            return "Metric{metricName='" + this.metricName + '\'' + ", common=" + this.common + ", namespace='" + this.namespace + '\'' + ", type='" + this.type + '\'' + ", timestamp=" + this.timestamp + ", value=" + this.value + ", tags=" + this.tags + '}';
        }
    }
}

