/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.websocket;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.time.SystemTimeSource;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.websocket.HandlersExtractor;
import datadog.trace.bootstrap.instrumentation.websocket.ResourceNameExtractor;

public abstract class HandlerContext {
    final Logger LOGGER = LoggerFactory.getLogger(HandlerContext.class);
    private final AgentSpan handshakeSpan;
    private AgentSpan websocketSpan;
    private final String sessionId;
    protected long msgChunks = 0L;
    protected long msgSize = 0L;
    private final CharSequence wsResourceName;
    protected long firstFrameTimestamp;

    public HandlerContext(AgentSpan handshakeSpan, String sessionId) {
        this.handshakeSpan = handshakeSpan;
        this.sessionId = sessionId;
        this.wsResourceName = ResourceNameExtractor.extractResourceName(handshakeSpan.getResourceName());
    }

    public AgentSpan getHandshakeSpan() {
        return this.handshakeSpan;
    }

    public AgentSpan getWebsocketSpan() {
        return this.websocketSpan;
    }

    public void setWebsocketSpan(AgentSpan websocketSpan) {
        this.websocketSpan = websocketSpan;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getMsgChunks() {
        return this.msgChunks;
    }

    public long getMsgSize() {
        return this.msgSize;
    }

    public CharSequence getWsResourceName() {
        return this.wsResourceName;
    }

    public long getFirstFrameTimestamp() {
        return this.firstFrameTimestamp;
    }

    public abstract CharSequence getMessageType();

    public void reset() {
        this.msgChunks = 0L;
        this.websocketSpan = null;
        this.msgSize = 0L;
        this.firstFrameTimestamp = 0L;
    }

    public static class Sender
    extends HandlerContext {
        private CharSequence msgType;

        public Sender(AgentSpan handshakeSpan, String sessionId) {
            super(handshakeSpan, sessionId);
        }

        @Override
        public CharSequence getMessageType() {
            return this.msgType;
        }

        @Override
        public void reset() {
            super.reset();
            this.msgType = null;
        }

        public void recordChunkData(CharSequence type, int size) {
            ++this.msgChunks;
            if (this.msgType == null) {
                this.msgType = type;
            }
            this.msgSize += (long)size;
        }
    }

    public static class Receiver
    extends HandlerContext {
        private boolean msgSizeExtractorInitialized = false;
        private HandlersExtractor.SizeCalculator msgSizeCalculator;

        public Receiver(AgentSpan handshakeSpan, String sessionId) {
            super(handshakeSpan, sessionId);
        }

        @Override
        public CharSequence getMessageType() {
            return this.msgSizeCalculator != null ? this.msgSizeCalculator.getFormat() : null;
        }

        public void recordChunkData(Object data, boolean partialDelivery) {
            if (this.msgChunks++ == 0L && partialDelivery) {
                this.firstFrameTimestamp = SystemTimeSource.INSTANCE.getCurrentTimeNanos();
            }
            if (data == null) {
                return;
            }
            if (!this.msgSizeExtractorInitialized) {
                this.msgSizeExtractorInitialized = true;
                this.msgSizeCalculator = HandlersExtractor.getSizeCalculator(data);
            }
            if (this.msgSizeCalculator != null) {
                try {
                    int sz = this.msgSizeCalculator.getLengthFunction().applyAsInt(data);
                    this.msgSize += (long)sz;
                    if (partialDelivery && sz == 0) {
                        --this.msgChunks;
                    }
                }
                catch (Throwable t) {
                    this.LOGGER.debug("Unable to calculate websocket message size for data type {}", (Object)data.getClass().getName(), (Object)t);
                }
            }
        }
    }
}

