/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.environment;

import datadog.trace.bootstrap.environment.SystemProperties;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;

public final class OperatingSystem {
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final String OS_ARCH_PROPERTY = "os.arch";

    private OperatingSystem() {
    }

    public static boolean isLinux() {
        return OperatingSystem.propertyContains(OS_NAME_PROPERTY, "linux");
    }

    public static boolean isWindows() {
        return OperatingSystem.propertyContains(OS_NAME_PROPERTY, "win");
    }

    public static boolean isMacOs() {
        return OperatingSystem.propertyContains(OS_NAME_PROPERTY, "mac");
    }

    public static boolean isAarch64() {
        return OperatingSystem.propertyContains(OS_ARCH_PROPERTY, "aarch64");
    }

    private static boolean propertyContains(String property, String content) {
        return SystemProperties.getOrDefault(property, "").toLowerCase(Locale.ROOT).contains(content);
    }

    public static boolean isMusl() {
        if (!OperatingSystem.isLinux()) {
            return false;
        }
        try {
            return OperatingSystem.isMuslJavaExecutable();
        }
        catch (IOException e) {
            try {
                return OperatingSystem.isMuslProcSelfMaps();
            }
            catch (IOException ignore) {
                return false;
            }
        }
    }

    private static boolean isMuslProcSelfMaps() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/self/maps"));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains("-musl-")) {
                    boolean bl = true;
                    return bl;
                }
                if (!line.contains("/libc.")) continue;
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    private static boolean isMuslJavaExecutable() throws IOException {
        byte[] magic = new byte[]{127, 69, 76, 70};
        byte[] prefix = new byte[]{47, 108, 100, 45};
        byte[] musl = new byte[]{109, 117, 115, 108};
        Path binary = Paths.get(SystemProperties.getOrDefault("java.home", ""), "bin", "java");
        byte[] buffer = new byte[4096];
        try (InputStream is = Files.newInputStream(binary, new OpenOption[0]);){
            int read = is.read(buffer, 0, 4);
            if (read != 4 || !OperatingSystem.containsArray(buffer, 0, magic)) {
                throw new IOException(Arrays.toString(buffer));
            }
            read = is.read(buffer);
            if (read <= 0) {
                throw new IOException();
            }
            int prefixPos = 0;
            for (int i = 0; i < read; ++i) {
                if (buffer[i] == prefix[prefixPos]) {
                    if (++prefixPos != prefix.length) continue;
                    boolean bl = OperatingSystem.containsArray(buffer, i + 1, musl);
                    return bl;
                }
                prefixPos = 0;
            }
        }
        return false;
    }

    private static boolean containsArray(byte[] container, int offset, byte[] contained) {
        for (int i = 0; i < contained.length; ++i) {
            int leftPos = offset + i;
            if (leftPos >= container.length) {
                return false;
            }
            if (container[leftPos] == contained[i]) continue;
            return false;
        }
        return true;
    }
}

