/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.TagMap;
import datadog.trace.api.function.TriConsumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class LegacyTagMap
extends HashMap<String, Object>
implements TagMap {
    private static final long serialVersionUID = 77473435283123683L;
    static final LegacyTagMap EMPTY = new LegacyTagMap().freeze();
    private boolean frozen = false;

    LegacyTagMap() {
    }

    LegacyTagMap(int capacity) {
        super(capacity);
    }

    LegacyTagMap(LegacyTagMap that) {
        super(that);
    }

    @Override
    public boolean isOptimized() {
        return false;
    }

    @Override
    public void clear() {
        this.checkWriteAccess();
        super.clear();
    }

    @Override
    public final LegacyTagMap freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public final void checkWriteAccess() {
        if (this.frozen) {
            throw new IllegalStateException("TagMap frozen");
        }
    }

    @Override
    public final TagMap copy() {
        return new LegacyTagMap(this);
    }

    @Override
    public final void fillMap(Map<? super String, Object> map) {
        map.putAll(this);
    }

    @Override
    public final void fillStringMap(Map<? super String, ? super String> stringMap) {
        for (Map.Entry entry : this.entrySet()) {
            stringMap.put((String)entry.getKey(), entry.getValue().toString());
        }
    }

    @Override
    public final void forEach(Consumer<? super TagMap.Entry> consumer) {
        for (Map.Entry entry : this.entrySet()) {
            consumer.accept(TagMap.Entry.newAnyEntry(entry));
        }
    }

    @Override
    public final <T> void forEach(T thisObj, BiConsumer<T, ? super TagMap.Entry> consumer) {
        for (Map.Entry entry : this.entrySet()) {
            consumer.accept(thisObj, TagMap.Entry.newAnyEntry(entry));
        }
    }

    @Override
    public final <T, U> void forEach(T thisObj, U otherObj, TriConsumer<T, U, ? super TagMap.Entry> consumer) {
        for (Map.Entry entry : this.entrySet()) {
            consumer.accept((U)thisObj, (TagMap.Entry)otherObj, (TagMap.Entry)((TagMap.Entry)TagMap.Entry.newAnyEntry(entry)));
        }
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, Object value) {
        Object prior = this.put(tag, value);
        return prior == null ? null : TagMap.Entry.newAnyEntry(tag, prior);
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, CharSequence value) {
        Object prior = this.put(tag, (Object)value);
        return prior == null ? null : TagMap.Entry.newAnyEntry(tag, prior);
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, boolean value) {
        return this.getAndSet(tag, (Object)value);
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, double value) {
        return this.getAndSet(tag, (Object)value);
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, float value) {
        return this.getAndSet(tag, Float.valueOf(value));
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, int value) {
        return this.getAndSet(tag, (Object)value);
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, long value) {
        return this.getAndSet(tag, (Object)value);
    }

    @Override
    public final TagMap.Entry getAndSet(TagMap.Entry newEntry) {
        return this.getAndSet(newEntry.tag(), newEntry.objectValue());
    }

    @Override
    public final TagMap.Entry getAndRemove(String tag) {
        Object prior = this.remove((Object)tag);
        return prior == null ? null : TagMap.Entry.newAnyEntry(tag, prior);
    }

    @Override
    public final Object getObject(String tag) {
        return this.get(tag);
    }

    @Override
    public final boolean getBoolean(String tag) {
        return this.getBooleanOrDefault(tag, false);
    }

    @Override
    public final boolean getBooleanOrDefault(String tag, boolean defaultValue) {
        Object result = this.get(tag);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Number) {
            Number number = (Number)result;
            return number.intValue() != 0;
        }
        return true;
    }

    @Override
    public double getDouble(String tag) {
        return this.getDoubleOrDefault(tag, 0.0);
    }

    @Override
    public final double getDoubleOrDefault(String tag, double defaultValue) {
        Object value = this.get(tag);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        return 0.0;
    }

    @Override
    public final long getLong(String tag) {
        return this.getLongOrDefault(tag, 0L);
    }

    @Override
    public final long getLongOrDefault(String tag, long defaultValue) {
        Object value = this.get(tag);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        return 0L;
    }

    @Override
    public final float getFloat(String tag) {
        return this.getFloatOrDefault(tag, 0.0f);
    }

    @Override
    public final float getFloatOrDefault(String tag, float defaultValue) {
        Object value = this.get(tag);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    @Override
    public final int getInt(String tag) {
        return this.getIntOrDefault(tag, 0);
    }

    @Override
    public final int getIntOrDefault(String tag, int defaultValue) {
        Object value = this.get(tag);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return 0;
    }

    @Override
    public final String getString(String tag) {
        Object value = this.get(tag);
        return value == null ? null : value.toString();
    }

    @Override
    public final TagMap.Entry getEntry(String tag) {
        Object value = this.get(tag);
        return value == null ? null : TagMap.Entry.newAnyEntry(tag, value);
    }

    @Override
    public void set(String tag, boolean value) {
        this.put(tag, (Object)value);
    }

    @Override
    public void set(String tag, CharSequence value) {
        this.put(tag, (Object)value);
    }

    @Override
    public void set(String tag, double value) {
        this.put(tag, (Object)value);
    }

    @Override
    public void set(String tag, float value) {
        this.put(tag, (Object)Float.valueOf(value));
    }

    @Override
    public void set(String tag, int value) {
        this.put(tag, (Object)value);
    }

    @Override
    public void set(String tag, long value) {
        this.put(tag, (Object)value);
    }

    @Override
    public void set(String tag, Object value) {
        this.put(tag, value);
    }

    @Override
    public void set(TagMap.Entry newEntry) {
        this.put(newEntry.tag(), newEntry.objectValue());
    }

    @Override
    public Object put(String key, Object value) {
        this.checkWriteAccess();
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.checkWriteAccess();
        super.putAll(m);
    }

    @Override
    public void putAll(TagMap that) {
        this.putAll((Map<? extends String, ? extends Object>)that);
    }

    @Override
    public Object remove(Object key) {
        this.checkWriteAccess();
        return super.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.checkWriteAccess();
        return super.remove(key, value);
    }

    @Override
    public boolean remove(String tag) {
        this.checkWriteAccess();
        return super.remove(tag) != null;
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        this.checkWriteAccess();
        return super.compute(key, remappingFunction);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ? extends Object> mappingFunction) {
        this.checkWriteAccess();
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        this.checkWriteAccess();
        return super.computeIfPresent(key, remappingFunction);
    }

    @Override
    public TagMap immutableCopy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this.copy().freeze();
    }

    @Override
    public Iterator<TagMap.Entry> iterator() {
        return new IteratorImpl(this);
    }

    @Override
    public Stream<TagMap.Entry> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private final class IteratorImpl
    implements Iterator<TagMap.Entry> {
        private Iterator<Map.Entry<String, Object>> wrappedIter;

        IteratorImpl(LegacyTagMap legacyMap) {
            this.wrappedIter = legacyMap.entrySet().iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.wrappedIter.hasNext();
        }

        @Override
        public final TagMap.Entry next() {
            return TagMap.Entry.newAnyEntry(this.wrappedIter.next());
        }
    }
}

