/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging;

import datadog.trace.api.Platform;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;

public class PrintStreamWrapper
extends PrintStream {
    private static final int LINE_SEPARATOR_LENGTH = Platform.isWindows() ? 2 : 1;
    private volatile boolean captureOutput = false;
    private volatile int currentSize = 0;
    private PrintStream capturingStream = null;

    public PrintStreamWrapper(PrintStream ps) {
        super(ps);
    }

    public OutputStream getOriginalPrintStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        super.println(x);
        if (this.captureOutput) {
            int outputLength = x.length() + LINE_SEPARATOR_LENGTH;
            if (this.currentSize + outputLength < 0xF00000) {
                PrintStreamWrapper printStreamWrapper = this;
                synchronized (printStreamWrapper) {
                    this.capturingStream.println(x);
                    this.currentSize += outputLength;
                }
            } else {
                this.captureOutput = false;
            }
        }
    }

    @Override
    public void println(Object x) {
        String s = String.valueOf(x);
        this.println(s);
    }

    public void startCapturing(Path filepath) {
        this.stopCapturing();
        try {
            if (filepath != null) {
                String logFile = filepath.toString();
                FileOutputStream fileOutputStream = new FileOutputStream(logFile);
                this.capturingStream = new PrintStream(fileOutputStream, true);
                this.captureOutput = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void stopCapturing() {
        if (this.capturingStream != null) {
            this.capturingStream.close();
            this.capturingStream = null;
        }
        this.currentSize = 0;
        this.captureOutput = false;
    }
}

