/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.otel.api.trace.Tracer;
import datadog.trace.bootstrap.otel.api.trace.TracerBuilder;
import datadog.trace.bootstrap.otel.api.trace.TracerProvider;
import datadog.trace.bootstrap.otel.shim.trace.OtelTracerBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelTracerProvider
implements TracerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelTracerProvider.class);
    private static final String DEFAULT_TRACER_NAME = "";
    public static final TracerProvider INSTANCE = new OtelTracerProvider();
    private final Map<String, Tracer> tracers = new HashMap<String, Tracer>();

    @Override
    public Tracer get(String instrumentationScopeName) {
        Tracer tracer = this.tracers.get(instrumentationScopeName);
        if (tracer == null) {
            tracer = this.tracerBuilder(instrumentationScopeName).build();
            this.tracers.put(instrumentationScopeName, tracer);
        }
        return tracer;
    }

    @Override
    public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
        Tracer tracer = this.tracers.get(instrumentationScopeName);
        if (tracer == null) {
            tracer = this.tracerBuilder(instrumentationScopeName).setInstrumentationVersion(instrumentationScopeVersion).build();
            this.tracers.put(instrumentationScopeName, tracer);
        }
        return tracer;
    }

    @Override
    public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        if (instrumentationScopeName.trim().isEmpty()) {
            LOGGER.debug("Tracer requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_TRACER_NAME;
        }
        return new OtelTracerBuilder(instrumentationScopeName);
    }
}

