/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.semconv.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.ContextCustomizer;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.HttpConstants;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.HttpRouteState;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import java.util.HashSet;
import java.util.Set;

public final class HttpServerRouteBuilder<REQUEST> {
    final HttpServerAttributesGetter<REQUEST, ?> getter;
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;

    HttpServerRouteBuilder(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @CanIgnoreReturnValue
    public HttpServerRouteBuilder<REQUEST> setKnownMethods(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    public ContextCustomizer<REQUEST> build() {
        HashSet<String> knownMethods = new HashSet<String>(this.knownMethods);
        return (context, request, startAttributes) -> {
            if (HttpRouteState.fromContextOrNull(context) != null) {
                return context;
            }
            String method = this.getter.getHttpRequestMethod(request);
            if (method == null || !knownMethods.contains(method)) {
                method = "HTTP";
            }
            return context.with(HttpRouteState.create(method, null, 0));
        };
    }
}

