/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.json.JsonWriter;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class BootstrapInitializationTelemetry {
    public static BootstrapInitializationTelemetry noOpInstance() {
        return NoOp.INSTANCE;
    }

    public static BootstrapInitializationTelemetry createFromForwarderPath(String forwarderPath) {
        return new JsonBased(new ForwarderJsonSender(forwarderPath));
    }

    public abstract void initMetaInfo(String var1, String var2);

    public abstract void onAbort(String var1);

    public abstract void onError(Throwable var1);

    public abstract void onFatalError(Throwable var1);

    public abstract void onError(String var1);

    public abstract void markIncomplete();

    public abstract void finish();

    public static final class ForwarderJsonSenderThread
    extends Thread {
        private final String forwarderPath;
        private final byte[] payload;

        public ForwarderJsonSenderThread(String forwarderPath, byte[] payload) {
            super("dd-forwarder-json-sender");
            this.forwarderPath = forwarderPath;
            this.payload = payload;
        }

        @Override
        @SuppressForbidden
        public void run() {
            ProcessBuilder builder = new ProcessBuilder(this.forwarderPath, "library_entrypoint");
            try {
                Process process = builder.start();
                try (OutputStream out = process.getOutputStream();){
                    out.write(this.payload);
                }
            }
            catch (Throwable e) {
                System.err.println("Failed to send telemetry: " + e.getMessage());
            }
        }
    }

    public static final class ForwarderJsonSender
    implements JsonSender {
        private final String forwarderPath;

        ForwarderJsonSender(String forwarderPath) {
            this.forwarderPath = forwarderPath;
        }

        @Override
        public void send(byte[] payload) {
            ForwarderJsonSenderThread t = new ForwarderJsonSenderThread(this.forwarderPath, payload);
            t.setDaemon(true);
            t.start();
        }
    }

    public static interface JsonSender {
        public void send(byte[] var1);
    }

    public static final class JsonBased
    extends BootstrapInitializationTelemetry {
        private final JsonSender sender;
        private final List<String> meta;
        private final List<String> points;
        private volatile boolean incomplete = false;

        JsonBased(JsonSender sender) {
            this.sender = sender;
            this.meta = new ArrayList<String>();
            this.points = new ArrayList<String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initMetaInfo(String attr, String value) {
            List<String> list = this.meta;
            synchronized (list) {
                this.meta.add(attr);
                this.meta.add(value);
            }
        }

        @Override
        public void onAbort(String reasonCode) {
            this.onPoint("library_entrypoint.abort", "reason:" + reasonCode);
            this.markIncomplete();
        }

        @Override
        public void onError(Throwable t) {
            this.onPoint("library_entrypoint.error", "error_type:" + t.getClass().getName());
        }

        @Override
        public void onFatalError(Throwable t) {
            this.onError(t);
            this.markIncomplete();
        }

        @Override
        public void onError(String reasonCode) {
            this.onPoint("library_entrypoint.error", "error_type:" + reasonCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPoint(String name, String tag) {
            List<String> list = this.points;
            synchronized (list) {
                this.points.add(name);
                this.points.add(tag);
            }
        }

        @Override
        public void markIncomplete() {
            this.incomplete = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            try (JsonWriter writer = new JsonWriter();){
                int i;
                writer.beginObject();
                writer.name("metadata").beginObject();
                List<String> list = this.meta;
                synchronized (list) {
                    i = 0;
                    while (i + 1 < this.meta.size()) {
                        writer.name(this.meta.get(i));
                        writer.value(this.meta.get(i + 1));
                        i += 2;
                    }
                }
                writer.endObject();
                writer.name("points").beginArray();
                list = this.points;
                synchronized (list) {
                    i = 0;
                    while (i + 1 < this.points.size()) {
                        writer.beginObject();
                        writer.name("name").value(this.points.get(i));
                        writer.name("tags").beginArray().value(this.points.get(i + 1)).endArray();
                        writer.endObject();
                        i += 2;
                    }
                    this.points.clear();
                }
                if (!this.incomplete) {
                    writer.beginObject().name("name").value("library_entrypoint.complete").endObject();
                }
                writer.endArray();
                writer.endObject();
                this.sender.send(writer.toByteArray());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static final class NoOp
    extends BootstrapInitializationTelemetry {
        static final NoOp INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        public void initMetaInfo(String attr, String value) {
        }

        @Override
        public void onAbort(String reasonCode) {
        }

        @Override
        public void onError(String reasonCode) {
        }

        @Override
        public void onFatalError(Throwable t) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void markIncomplete() {
        }

        @Override
        public void finish() {
        }
    }
}

