/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.git;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.civisibility.telemetry.tag.GitProviderDiscrepant;
import datadog.trace.api.civisibility.telemetry.tag.GitProviderExpected;
import datadog.trace.api.git.CommitInfo;
import datadog.trace.api.git.GitInfo;
import datadog.trace.api.git.GitInfoBuilder;
import datadog.trace.api.git.GitUtils;
import datadog.trace.api.git.PersonInfo;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import datadog.trace.util.Strings;
import javax.annotation.Nullable;

public class UserSuppliedGitInfoBuilder
implements GitInfoBuilder {
    public static final String DD_GIT_REPOSITORY_URL = "git.repository.url";
    public static final String DD_GIT_BRANCH = "git.branch";
    public static final String DD_GIT_TAG = "git.tag";
    public static final String DD_GIT_COMMIT_SHA = "git.commit.sha";
    public static final String DD_GIT_COMMIT_MESSAGE = "git.commit.message";
    public static final String DD_GIT_COMMIT_AUTHOR_NAME = "git.commit.author.name";
    public static final String DD_GIT_COMMIT_AUTHOR_EMAIL = "git.commit.author.email";
    public static final String DD_GIT_COMMIT_AUTHOR_DATE = "git.commit.author.date";
    public static final String DD_GIT_COMMIT_COMMITTER_NAME = "git.commit.committer.name";
    public static final String DD_GIT_COMMIT_COMMITTER_EMAIL = "git.commit.committer.email";
    public static final String DD_GIT_COMMIT_COMMITTER_DATE = "git.commit.committer.date";
    private static final Logger log = LoggerFactory.getLogger(UserSuppliedGitInfoBuilder.class);

    @Override
    public GitInfo build(@Nullable String repositoryPath) {
        String gitCommitCommitterDate;
        String gitCommitCommitterEmail;
        String gitCommitCommitterName;
        String gitCommitAuthorDate;
        String gitCommitAuthorEmail;
        String gitCommitSha;
        ConfigProvider configProvider = ConfigProvider.getInstance();
        String gitRepositoryUrl = configProvider.getString(DD_GIT_REPOSITORY_URL);
        if (gitRepositoryUrl == null) {
            gitRepositoryUrl = Config.get().getGlobalTags().get("git.repository_url");
        }
        String gitTag = configProvider.getString(DD_GIT_TAG);
        String gitBranch = null;
        String gitBranchOrTag = configProvider.getString(DD_GIT_BRANCH);
        if (gitBranchOrTag != null) {
            if (!GitUtils.isTagReference(gitBranchOrTag)) {
                gitBranch = GitUtils.normalizeBranch(gitBranchOrTag);
            } else if (gitTag == null) {
                gitTag = GitUtils.normalizeTag(gitBranchOrTag);
            }
        }
        if ((gitCommitSha = configProvider.getString(DD_GIT_COMMIT_SHA)) == null) {
            gitCommitSha = Config.get().getGlobalTags().get(DD_GIT_COMMIT_SHA);
        }
        String gitCommitMessage = configProvider.getString(DD_GIT_COMMIT_MESSAGE);
        String gitCommitAuthorName = configProvider.getString(DD_GIT_COMMIT_AUTHOR_NAME);
        GitInfo gitInfo = new GitInfo(gitRepositoryUrl, gitBranch, gitTag, new CommitInfo(gitCommitSha, new PersonInfo(gitCommitAuthorName, gitCommitAuthorEmail = configProvider.getString(DD_GIT_COMMIT_AUTHOR_EMAIL), gitCommitAuthorDate = configProvider.getString(DD_GIT_COMMIT_AUTHOR_DATE)), new PersonInfo(gitCommitCommitterName = configProvider.getString(DD_GIT_COMMIT_COMMITTER_NAME), gitCommitCommitterEmail = configProvider.getString(DD_GIT_COMMIT_COMMITTER_EMAIL), gitCommitCommitterDate = configProvider.getString(DD_GIT_COMMIT_COMMITTER_DATE)), gitCommitMessage));
        if (!gitInfo.isEmpty()) {
            String commitSha;
            String repoUrl = gitInfo.getRepositoryURL();
            if (repoUrl == null || repoUrl.isEmpty()) {
                log.error("Could not resolve git repository URL (can be provided via " + Strings.propertyNameToEnvironmentVariableName(DD_GIT_REPOSITORY_URL) + " env var or corresponding system property, " + "tags" + " config property or by embedding git metadata at build time)");
            }
            if (!GitUtils.isValidCommitSha(commitSha = gitInfo.getCommit().getSha())) {
                log.error("Git commit SHA could not be resolved or is invalid: " + commitSha + " (can be provided via " + Strings.propertyNameToEnvironmentVariableName(DD_GIT_COMMIT_SHA) + " env var or corresponding system property, " + "tags" + " config property or by embedding git metadata at build time; must be a full-length SHA");
            }
        }
        return gitInfo;
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public GitProviderExpected providerAsExpected() {
        return GitProviderExpected.USER_SUPPLIED;
    }

    @Override
    public GitProviderDiscrepant providerAsDiscrepant() {
        return GitProviderDiscrepant.USER_SUPPLIED;
    }
}

