/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.env.CapturedEnvironment;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.util.TraceUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProcessTags {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTags.class);
    private static boolean enabled = Config.get().isExperimentalPropagateProcessTagsEnabled();

    private ProcessTags() {
    }

    public static synchronized void addTag(String key, String value) {
        if (enabled) {
            Lazy.TAGS.put(key, value);
            Lazy.serializedForm = null;
            Lazy.listForm = null;
        }
    }

    public static List<String> getTagsAsList() {
        if (!enabled) {
            return null;
        }
        List<String> listForm = Lazy.listForm;
        if (listForm != null) {
            return listForm;
        }
        Lazy.calculate();
        return Lazy.listForm;
    }

    public static UTF8BytesString getTagsForSerialization() {
        if (!enabled) {
            return null;
        }
        UTF8BytesString serializedForm = Lazy.serializedForm;
        if (serializedForm != null) {
            return serializedForm;
        }
        Lazy.calculate();
        return Lazy.serializedForm;
    }

    static void empty() {
        Lazy.TAGS.clear();
        Lazy.serializedForm = null;
        Lazy.listForm = null;
    }

    static void reset() {
        ProcessTags.empty();
        enabled = Config.get().isExperimentalPropagateProcessTagsEnabled();
        Lazy.TAGS.putAll(Lazy.loadTags());
    }

    private static class Lazy {
        static final Map<String, String> TAGS = Lazy.loadTags();
        static volatile UTF8BytesString serializedForm;
        static volatile List<String> listForm;

        private Lazy() {
        }

        private static Map<String, String> loadTags() {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            if (enabled) {
                try {
                    Lazy.fillBaseTags(tags);
                    Lazy.fillJbossTags(tags);
                }
                catch (Throwable t) {
                    LOGGER.debug("Unable to calculate default process tags", t);
                }
            }
            return tags;
        }

        private static void insertSysPropIfPresent(Map<String, String> tags, String propKey, String tagKey) {
            String value = System.getProperty(propKey);
            if (value != null) {
                tags.put(tagKey, value);
            }
        }

        private static boolean insertLastPathSegmentIfPresent(Map<String, String> tags, String path, String tagKey) {
            if (path == null || path.isEmpty()) {
                return false;
            }
            try {
                Path p = Paths.get(path, new String[0]).getFileName();
                if (p != null) {
                    tags.put(tagKey, p.toString());
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        private static void fillBaseTags(Map<String, String> tags) {
            CapturedEnvironment.ProcessInfo processInfo = CapturedEnvironment.get().getProcessInfo();
            if (processInfo.mainClass != null) {
                tags.put("entrypoint.name", processInfo.mainClass);
            }
            if (processInfo.jarFile != null) {
                String jarName = processInfo.jarFile.getName();
                tags.put("entrypoint.name", jarName.substring(0, jarName.length() - 4));
                Lazy.insertLastPathSegmentIfPresent(tags, processInfo.jarFile.getParent(), "entrypoint.basedir");
            }
            Lazy.insertLastPathSegmentIfPresent(tags, System.getProperty("user.dir"), "entrypoint.workdir");
        }

        private static void fillJbossTags(Map<String, String> tags) {
            if (Lazy.insertLastPathSegmentIfPresent(tags, System.getProperty("jboss.home.dir"), "jboss.home")) {
                Lazy.insertSysPropIfPresent(tags, "jboss.server.name", "server.name");
                tags.put("jboss.mode", System.getProperties().containsKey("[Standalone]") ? "standalone" : "domain");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void calculate() {
            if (listForm != null || TAGS.isEmpty()) {
                return;
            }
            Map<String, String> map = TAGS;
            synchronized (map) {
                Stream<String> tagStream = TAGS.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + TraceUtils.normalizeTag((String)entry.getValue()));
                listForm = Collections.unmodifiableList(tagStream.collect(Collectors.toList()));
                serializedForm = UTF8BytesString.create(String.join((CharSequence)",", listForm));
            }
        }
    }
}

