/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.MonitorConfigPolicyCreateRequest;
import com.datadog.api.client.v2.model.MonitorConfigPolicyEditRequest;
import com.datadog.api.client.v2.model.MonitorConfigPolicyListResponse;
import com.datadog.api.client.v2.model.MonitorConfigPolicyResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class MonitorsApi {
    private ApiClient apiClient;

    public MonitorsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public MonitorsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MonitorConfigPolicyResponse createMonitorConfigPolicy(MonitorConfigPolicyCreateRequest body) throws ApiException {
        return this.createMonitorConfigPolicyWithHttpInfo(body).getData();
    }

    public CompletableFuture<MonitorConfigPolicyResponse> createMonitorConfigPolicyAsync(MonitorConfigPolicyCreateRequest body) {
        return this.createMonitorConfigPolicyWithHttpInfoAsync(body).thenApply(response -> (MonitorConfigPolicyResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyResponse> createMonitorConfigPolicyWithHttpInfo(MonitorConfigPolicyCreateRequest body) throws ApiException {
        MonitorConfigPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> createMonitorConfigPolicyWithHttpInfoAsync(MonitorConfigPolicyCreateRequest body) {
        Invocation.Builder builder;
        MonitorConfigPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.createMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public void deleteMonitorConfigPolicy(String policyId) throws ApiException {
        this.deleteMonitorConfigPolicyWithHttpInfo(policyId);
    }

    public CompletableFuture<Void> deleteMonitorConfigPolicyAsync(String policyId) {
        return this.deleteMonitorConfigPolicyWithHttpInfoAsync(policyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteMonitorConfigPolicyWithHttpInfo(String policyId) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteMonitorConfigPolicyWithHttpInfoAsync(String policyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling deleteMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.deleteMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public MonitorConfigPolicyResponse getMonitorConfigPolicy(String policyId) throws ApiException {
        return this.getMonitorConfigPolicyWithHttpInfo(policyId).getData();
    }

    public CompletableFuture<MonitorConfigPolicyResponse> getMonitorConfigPolicyAsync(String policyId) {
        return this.getMonitorConfigPolicyWithHttpInfoAsync(policyId).thenApply(response -> (MonitorConfigPolicyResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyResponse> getMonitorConfigPolicyWithHttpInfo(String policyId) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> getMonitorConfigPolicyWithHttpInfoAsync(String policyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling getMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.getMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public MonitorConfigPolicyListResponse listMonitorConfigPolicies() throws ApiException {
        return this.listMonitorConfigPoliciesWithHttpInfo().getData();
    }

    public CompletableFuture<MonitorConfigPolicyListResponse> listMonitorConfigPoliciesAsync() {
        return this.listMonitorConfigPoliciesWithHttpInfoAsync().thenApply(response -> (MonitorConfigPolicyListResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyListResponse> listMonitorConfigPoliciesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.listMonitorConfigPolicies", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyListResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyListResponse>> listMonitorConfigPoliciesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/monitor/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.listMonitorConfigPolicies", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyListResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyListResponse>(){});
    }

    public MonitorConfigPolicyResponse updateMonitorConfigPolicy(String policyId, MonitorConfigPolicyEditRequest body) throws ApiException {
        return this.updateMonitorConfigPolicyWithHttpInfo(policyId, body).getData();
    }

    public CompletableFuture<MonitorConfigPolicyResponse> updateMonitorConfigPolicyAsync(String policyId, MonitorConfigPolicyEditRequest body) {
        return this.updateMonitorConfigPolicyWithHttpInfoAsync(policyId, body).thenApply(response -> (MonitorConfigPolicyResponse)response.getData());
    }

    public ApiResponse<MonitorConfigPolicyResponse> updateMonitorConfigPolicyWithHttpInfo(String policyId, MonitorConfigPolicyEditRequest body) throws ApiException {
        MonitorConfigPolicyEditRequest localVarPostBody = body;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling updateMonitorConfigPolicy");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorConfigPolicy");
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> updateMonitorConfigPolicyWithHttpInfoAsync(String policyId, MonitorConfigPolicyEditRequest body) {
        Invocation.Builder builder;
        MonitorConfigPolicyEditRequest localVarPostBody = body;
        if (policyId == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling updateMonitorConfigPolicy"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateMonitorConfigPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/monitor/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.MonitorsApi.updateMonitorConfigPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>> result = new CompletableFuture<ApiResponse<MonitorConfigPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorConfigPolicyResponse>(){});
    }
}

