/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsBasicAuthOauthClientType;
import com.datadog.api.client.v1.model.SyntheticsBasicAuthOauthTokenApiAuthentication;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"accessTokenUrl", "audience", "clientId", "clientSecret", "resource", "scope", "tokenApiAuthentication", "type"})
public class SyntheticsBasicAuthOauthClient {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCESS_TOKEN_URL = "accessTokenUrl";
    private String accessTokenUrl;
    public static final String JSON_PROPERTY_AUDIENCE = "audience";
    private String audience;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "clientSecret";
    private String clientSecret;
    public static final String JSON_PROPERTY_RESOURCE = "resource";
    private String resource;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_TOKEN_API_AUTHENTICATION = "tokenApiAuthentication";
    private SyntheticsBasicAuthOauthTokenApiAuthentication tokenApiAuthentication;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsBasicAuthOauthClientType type = SyntheticsBasicAuthOauthClientType.OAUTH_CLIENT;

    public SyntheticsBasicAuthOauthClient() {
    }

    @JsonCreator
    public SyntheticsBasicAuthOauthClient(@JsonProperty(required=true, value="accessTokenUrl") String accessTokenUrl, @JsonProperty(required=true, value="clientId") String clientId, @JsonProperty(required=true, value="clientSecret") String clientSecret, @JsonProperty(required=true, value="tokenApiAuthentication") SyntheticsBasicAuthOauthTokenApiAuthentication tokenApiAuthentication) {
        this.accessTokenUrl = accessTokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenApiAuthentication = tokenApiAuthentication;
        this.unparsed |= !tokenApiAuthentication.isValid();
    }

    public SyntheticsBasicAuthOauthClient accessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
        return this;
    }

    @JsonProperty(value="accessTokenUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public SyntheticsBasicAuthOauthClient audience(String audience) {
        this.audience = audience;
        return this;
    }

    @Nullable
    @JsonProperty(value="audience")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public SyntheticsBasicAuthOauthClient clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SyntheticsBasicAuthOauthClient clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public SyntheticsBasicAuthOauthClient resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public SyntheticsBasicAuthOauthClient scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public SyntheticsBasicAuthOauthClient tokenApiAuthentication(SyntheticsBasicAuthOauthTokenApiAuthentication tokenApiAuthentication) {
        this.tokenApiAuthentication = tokenApiAuthentication;
        this.unparsed |= !tokenApiAuthentication.isValid();
        return this;
    }

    @JsonProperty(value="tokenApiAuthentication")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsBasicAuthOauthTokenApiAuthentication getTokenApiAuthentication() {
        return this.tokenApiAuthentication;
    }

    public void setTokenApiAuthentication(SyntheticsBasicAuthOauthTokenApiAuthentication tokenApiAuthentication) {
        if (!tokenApiAuthentication.isValid()) {
            this.unparsed = true;
        }
        this.tokenApiAuthentication = tokenApiAuthentication;
    }

    public SyntheticsBasicAuthOauthClient type(SyntheticsBasicAuthOauthClientType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsBasicAuthOauthClientType getType() {
        return this.type;
    }

    public void setType(SyntheticsBasicAuthOauthClientType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBasicAuthOauthClient syntheticsBasicAuthOauthClient = (SyntheticsBasicAuthOauthClient)o;
        return Objects.equals(this.accessTokenUrl, syntheticsBasicAuthOauthClient.accessTokenUrl) && Objects.equals(this.audience, syntheticsBasicAuthOauthClient.audience) && Objects.equals(this.clientId, syntheticsBasicAuthOauthClient.clientId) && Objects.equals(this.clientSecret, syntheticsBasicAuthOauthClient.clientSecret) && Objects.equals(this.resource, syntheticsBasicAuthOauthClient.resource) && Objects.equals(this.scope, syntheticsBasicAuthOauthClient.scope) && Objects.equals(this.tokenApiAuthentication, syntheticsBasicAuthOauthClient.tokenApiAuthentication) && Objects.equals(this.type, syntheticsBasicAuthOauthClient.type);
    }

    public int hashCode() {
        return Objects.hash(this.accessTokenUrl, this.audience, this.clientId, this.clientSecret, this.resource, this.scope, this.tokenApiAuthentication, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBasicAuthOauthClient {\n");
        sb.append("    accessTokenUrl: ").append(this.toIndentedString(this.accessTokenUrl)).append("\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tokenApiAuthentication: ").append(this.toIndentedString(this.tokenApiAuthentication)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

