/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.WidgetSort;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation", "facet", "order"})
public class LogQueryDefinitionGroupBySort {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private String aggregation;
    public static final String JSON_PROPERTY_FACET = "facet";
    private String facet;
    public static final String JSON_PROPERTY_ORDER = "order";
    private WidgetSort order;

    public LogQueryDefinitionGroupBySort() {
    }

    @JsonCreator
    public LogQueryDefinitionGroupBySort(@JsonProperty(required=true, value="aggregation") String aggregation, @JsonProperty(required=true, value="order") WidgetSort order) {
        this.aggregation = aggregation;
        this.order = order;
        this.unparsed |= !order.isValid();
    }

    public LogQueryDefinitionGroupBySort aggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public LogQueryDefinitionGroupBySort facet(String facet) {
        this.facet = facet;
        return this;
    }

    @Nullable
    @JsonProperty(value="facet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public LogQueryDefinitionGroupBySort order(WidgetSort order) {
        this.order = order;
        this.unparsed |= !order.isValid();
        return this;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetSort getOrder() {
        return this.order;
    }

    public void setOrder(WidgetSort order) {
        if (!order.isValid()) {
            this.unparsed = true;
        }
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogQueryDefinitionGroupBySort logQueryDefinitionGroupBySort = (LogQueryDefinitionGroupBySort)o;
        return Objects.equals(this.aggregation, logQueryDefinitionGroupBySort.aggregation) && Objects.equals(this.facet, logQueryDefinitionGroupBySort.facet) && Objects.equals(this.order, logQueryDefinitionGroupBySort.order);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.facet, this.order);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogQueryDefinitionGroupBySort {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    facet: ").append(this.toIndentedString(this.facet)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

