/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLORawErrorBudgetRemaining;
import com.datadog.api.client.v1.model.SLOTimeframe;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"error", "indexed_at", "raw_error_budget_remaining", "span_precision", "status", "target", "timeframe"})
public class SLOOverallStatuses {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ERROR = "error";
    private JsonNullable<String> error = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INDEXED_AT = "indexed_at";
    private Long indexedAt;
    public static final String JSON_PROPERTY_RAW_ERROR_BUDGET_REMAINING = "raw_error_budget_remaining";
    private SLORawErrorBudgetRemaining rawErrorBudgetRemaining;
    public static final String JSON_PROPERTY_SPAN_PRECISION = "span_precision";
    private Long spanPrecision;
    public static final String JSON_PROPERTY_STATUS = "status";
    private JsonNullable<Double> status = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TARGET = "target";
    private Double target;
    public static final String JSON_PROPERTY_TIMEFRAME = "timeframe";
    private SLOTimeframe timeframe;

    public SLOOverallStatuses error(String error) {
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getError() {
        return (String)this.error.orElse(null);
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getError_JsonNullable() {
        return this.error;
    }

    @JsonProperty(value="error")
    public void setError_JsonNullable(JsonNullable<String> error) {
        this.error = error;
    }

    public void setError(String error) {
        this.error = JsonNullable.of((Object)error);
    }

    public SLOOverallStatuses indexedAt(Long indexedAt) {
        this.indexedAt = indexedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="indexed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedAt() {
        return this.indexedAt;
    }

    public void setIndexedAt(Long indexedAt) {
        this.indexedAt = indexedAt;
    }

    public SLOOverallStatuses rawErrorBudgetRemaining(SLORawErrorBudgetRemaining rawErrorBudgetRemaining) {
        this.rawErrorBudgetRemaining = rawErrorBudgetRemaining;
        this.unparsed |= rawErrorBudgetRemaining.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="raw_error_budget_remaining")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLORawErrorBudgetRemaining getRawErrorBudgetRemaining() {
        return this.rawErrorBudgetRemaining;
    }

    public void setRawErrorBudgetRemaining(SLORawErrorBudgetRemaining rawErrorBudgetRemaining) {
        this.rawErrorBudgetRemaining = rawErrorBudgetRemaining;
    }

    public SLOOverallStatuses spanPrecision(Long spanPrecision) {
        this.spanPrecision = spanPrecision;
        return this;
    }

    @Nullable
    @JsonProperty(value="span_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSpanPrecision() {
        return this.spanPrecision;
    }

    public void setSpanPrecision(Long spanPrecision) {
        this.spanPrecision = spanPrecision;
    }

    public SLOOverallStatuses status(Double status) {
        this.status = JsonNullable.of((Object)status);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Double getStatus() {
        return (Double)this.status.orElse(null);
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Double> getStatus_JsonNullable() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus_JsonNullable(JsonNullable<Double> status) {
        this.status = status;
    }

    public void setStatus(Double status) {
        this.status = JsonNullable.of((Object)status);
    }

    public SLOOverallStatuses target(Double target) {
        this.target = target;
        return this;
    }

    @Nullable
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTarget() {
        return this.target;
    }

    public void setTarget(Double target) {
        this.target = target;
    }

    public SLOOverallStatuses timeframe(SLOTimeframe timeframe) {
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="timeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOTimeframe getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(SLOTimeframe timeframe) {
        if (!timeframe.isValid()) {
            this.unparsed = true;
        }
        this.timeframe = timeframe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOOverallStatuses sloOverallStatuses = (SLOOverallStatuses)o;
        return Objects.equals(this.error, sloOverallStatuses.error) && Objects.equals(this.indexedAt, sloOverallStatuses.indexedAt) && Objects.equals(this.rawErrorBudgetRemaining, sloOverallStatuses.rawErrorBudgetRemaining) && Objects.equals(this.spanPrecision, sloOverallStatuses.spanPrecision) && Objects.equals(this.status, sloOverallStatuses.status) && Objects.equals(this.target, sloOverallStatuses.target) && Objects.equals(this.timeframe, sloOverallStatuses.timeframe);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.indexedAt, this.rawErrorBudgetRemaining, this.spanPrecision, this.status, this.target, this.timeframe);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOOverallStatuses {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    indexedAt: ").append(this.toIndentedString(this.indexedAt)).append("\n");
        sb.append("    rawErrorBudgetRemaining: ").append(this.toIndentedString(this.rawErrorBudgetRemaining)).append("\n");
        sb.append("    spanPrecision: ").append(this.toIndentedString(this.spanPrecision)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    timeframe: ").append(this.toIndentedString(this.timeframe)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

