/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.ListStreamSource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"data_source", "indexes", "query_string", "storage"})
public class ListStreamQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private ListStreamSource dataSource = ListStreamSource.APM_ISSUE_STREAM;
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_QUERY_STRING = "query_string";
    private String queryString;
    public static final String JSON_PROPERTY_STORAGE = "storage";
    private String storage;

    public ListStreamQuery() {
    }

    @JsonCreator
    public ListStreamQuery(@JsonProperty(required=true, value="data_source") ListStreamSource dataSource, @JsonProperty(required=true, value="query_string") String queryString) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        this.queryString = queryString;
    }

    public ListStreamQuery dataSource(ListStreamSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListStreamSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ListStreamSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public ListStreamQuery indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public ListStreamQuery addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public ListStreamQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @JsonProperty(value="query_string")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public ListStreamQuery storage(String storage) {
        this.storage = storage;
        return this;
    }

    @Nullable
    @JsonProperty(value="storage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListStreamQuery listStreamQuery = (ListStreamQuery)o;
        return Objects.equals(this.dataSource, listStreamQuery.dataSource) && Objects.equals(this.indexes, listStreamQuery.indexes) && Objects.equals(this.queryString, listStreamQuery.queryString) && Objects.equals(this.storage, listStreamQuery.storage);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.indexes, this.queryString, this.storage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListStreamQuery {\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    queryString: ").append(this.toIndentedString(this.queryString)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

