/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.DORAGitInfo;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"custom_tags", "env", "finished_at", "git", "name", "services", "severity", "started_at", "team", "version"})
public class DORAIncidentObjectAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_TAGS = "custom_tags";
    private JsonNullable<List<String>> customTags = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ENV = "env";
    private String env;
    public static final String JSON_PROPERTY_FINISHED_AT = "finished_at";
    private Long finishedAt;
    public static final String JSON_PROPERTY_GIT = "git";
    private DORAGitInfo git;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<String> services = null;
    public static final String JSON_PROPERTY_SEVERITY = "severity";
    private String severity;
    public static final String JSON_PROPERTY_STARTED_AT = "started_at";
    private Long startedAt;
    public static final String JSON_PROPERTY_TEAM = "team";
    private String team;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    private Map<String, Object> additionalProperties;

    public DORAIncidentObjectAttributes() {
    }

    @JsonCreator
    public DORAIncidentObjectAttributes(@JsonProperty(required=true, value="started_at") Long startedAt) {
        this.startedAt = startedAt;
    }

    public DORAIncidentObjectAttributes customTags(List<String> customTags) {
        this.customTags = JsonNullable.of(customTags);
        return this;
    }

    public DORAIncidentObjectAttributes addCustomTagsItem(String customTagsItem) {
        if (this.customTags == null || !this.customTags.isPresent()) {
            this.customTags = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.customTags.get()).add(customTagsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getCustomTags() {
        return (List)this.customTags.orElse(null);
    }

    @JsonProperty(value="custom_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getCustomTags_JsonNullable() {
        return this.customTags;
    }

    @JsonProperty(value="custom_tags")
    public void setCustomTags_JsonNullable(JsonNullable<List<String>> customTags) {
        this.customTags = customTags;
    }

    public void setCustomTags(List<String> customTags) {
        this.customTags = JsonNullable.of(customTags);
    }

    public DORAIncidentObjectAttributes env(String env) {
        this.env = env;
        return this;
    }

    @Nullable
    @JsonProperty(value="env")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public DORAIncidentObjectAttributes finishedAt(Long finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="finished_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(Long finishedAt) {
        this.finishedAt = finishedAt;
    }

    public DORAIncidentObjectAttributes git(DORAGitInfo git) {
        this.git = git;
        this.unparsed |= git.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="git")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DORAGitInfo getGit() {
        return this.git;
    }

    public void setGit(DORAGitInfo git) {
        this.git = git;
    }

    public DORAIncidentObjectAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DORAIncidentObjectAttributes services(List<String> services) {
        this.services = services;
        return this;
    }

    public DORAIncidentObjectAttributes addServicesItem(String servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public DORAIncidentObjectAttributes severity(String severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    @JsonProperty(value="severity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public DORAIncidentObjectAttributes startedAt(Long startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @JsonProperty(value="started_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    public DORAIncidentObjectAttributes team(String team) {
        this.team = team;
        return this;
    }

    @Nullable
    @JsonProperty(value="team")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public DORAIncidentObjectAttributes version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonAnySetter
    public DORAIncidentObjectAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DORAIncidentObjectAttributes doraIncidentObjectAttributes = (DORAIncidentObjectAttributes)o;
        return Objects.equals(this.customTags, doraIncidentObjectAttributes.customTags) && Objects.equals(this.env, doraIncidentObjectAttributes.env) && Objects.equals(this.finishedAt, doraIncidentObjectAttributes.finishedAt) && Objects.equals(this.git, doraIncidentObjectAttributes.git) && Objects.equals(this.name, doraIncidentObjectAttributes.name) && Objects.equals(this.services, doraIncidentObjectAttributes.services) && Objects.equals(this.severity, doraIncidentObjectAttributes.severity) && Objects.equals(this.startedAt, doraIncidentObjectAttributes.startedAt) && Objects.equals(this.team, doraIncidentObjectAttributes.team) && Objects.equals(this.version, doraIncidentObjectAttributes.version) && Objects.equals(this.additionalProperties, doraIncidentObjectAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.customTags, this.env, this.finishedAt, this.git, this.name, this.services, this.severity, this.startedAt, this.team, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DORAIncidentObjectAttributes {\n");
        sb.append("    customTags: ").append(this.toIndentedString(this.customTags)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    git: ").append(this.toIndentedString(this.git)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

