/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.GlobalVariableJsonPatchRequest;
import com.datadog.api.client.v2.model.GlobalVariableResponse;
import com.datadog.api.client.v2.model.OnDemandConcurrencyCapAttributes;
import com.datadog.api.client.v2.model.OnDemandConcurrencyCapResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class SyntheticsApi {
    private ApiClient apiClient;

    public SyntheticsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SyntheticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OnDemandConcurrencyCapResponse getOnDemandConcurrencyCap() throws ApiException {
        return this.getOnDemandConcurrencyCapWithHttpInfo().getData();
    }

    public CompletableFuture<OnDemandConcurrencyCapResponse> getOnDemandConcurrencyCapAsync() {
        return this.getOnDemandConcurrencyCapWithHttpInfoAsync().thenApply(response -> (OnDemandConcurrencyCapResponse)response.getData());
    }

    public ApiResponse<OnDemandConcurrencyCapResponse> getOnDemandConcurrencyCapWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/synthetics/settings/on_demand_concurrency_cap";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SyntheticsApi.getOnDemandConcurrencyCap", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnDemandConcurrencyCapResponse>(){});
    }

    public CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>> getOnDemandConcurrencyCapWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/synthetics/settings/on_demand_concurrency_cap";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SyntheticsApi.getOnDemandConcurrencyCap", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>> result = new CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnDemandConcurrencyCapResponse>(){});
    }

    public GlobalVariableResponse patchGlobalVariable(String variableId, GlobalVariableJsonPatchRequest body) throws ApiException {
        return this.patchGlobalVariableWithHttpInfo(variableId, body).getData();
    }

    public CompletableFuture<GlobalVariableResponse> patchGlobalVariableAsync(String variableId, GlobalVariableJsonPatchRequest body) {
        return this.patchGlobalVariableWithHttpInfoAsync(variableId, body).thenApply(response -> (GlobalVariableResponse)response.getData());
    }

    public ApiResponse<GlobalVariableResponse> patchGlobalVariableWithHttpInfo(String variableId, GlobalVariableJsonPatchRequest body) throws ApiException {
        GlobalVariableJsonPatchRequest localVarPostBody = body;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling patchGlobalVariable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchGlobalVariable");
        }
        String localVarPath = "/api/v2/synthetics/variables/{variable_id}/jsonpatch".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SyntheticsApi.patchGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GlobalVariableResponse>(){});
    }

    public CompletableFuture<ApiResponse<GlobalVariableResponse>> patchGlobalVariableWithHttpInfoAsync(String variableId, GlobalVariableJsonPatchRequest body) {
        Invocation.Builder builder;
        GlobalVariableJsonPatchRequest localVarPostBody = body;
        if (variableId == null) {
            CompletableFuture<ApiResponse<GlobalVariableResponse>> result = new CompletableFuture<ApiResponse<GlobalVariableResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'variableId' when calling patchGlobalVariable"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<GlobalVariableResponse>> result = new CompletableFuture<ApiResponse<GlobalVariableResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling patchGlobalVariable"));
            return result;
        }
        String localVarPath = "/api/v2/synthetics/variables/{variable_id}/jsonpatch".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SyntheticsApi.patchGlobalVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GlobalVariableResponse>> result = new CompletableFuture<ApiResponse<GlobalVariableResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GlobalVariableResponse>(){});
    }

    public OnDemandConcurrencyCapResponse setOnDemandConcurrencyCap(OnDemandConcurrencyCapAttributes body) throws ApiException {
        return this.setOnDemandConcurrencyCapWithHttpInfo(body).getData();
    }

    public CompletableFuture<OnDemandConcurrencyCapResponse> setOnDemandConcurrencyCapAsync(OnDemandConcurrencyCapAttributes body) {
        return this.setOnDemandConcurrencyCapWithHttpInfoAsync(body).thenApply(response -> (OnDemandConcurrencyCapResponse)response.getData());
    }

    public ApiResponse<OnDemandConcurrencyCapResponse> setOnDemandConcurrencyCapWithHttpInfo(OnDemandConcurrencyCapAttributes body) throws ApiException {
        OnDemandConcurrencyCapAttributes localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setOnDemandConcurrencyCap");
        }
        String localVarPath = "/api/v2/synthetics/settings/on_demand_concurrency_cap";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SyntheticsApi.setOnDemandConcurrencyCap", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnDemandConcurrencyCapResponse>(){});
    }

    public CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>> setOnDemandConcurrencyCapWithHttpInfoAsync(OnDemandConcurrencyCapAttributes body) {
        Invocation.Builder builder;
        OnDemandConcurrencyCapAttributes localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>> result = new CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling setOnDemandConcurrencyCap"));
            return result;
        }
        String localVarPath = "/api/v2/synthetics/settings/on_demand_concurrency_cap";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SyntheticsApi.setOnDemandConcurrencyCap", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>> result = new CompletableFuture<ApiResponse<OnDemandConcurrencyCapResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnDemandConcurrencyCapResponse>(){});
    }
}

