/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CaseTypeCreateRequest;
import com.datadog.api.client.v2.model.CaseTypeResponse;
import com.datadog.api.client.v2.model.CaseTypesResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class CaseManagementTypeApi {
    private ApiClient apiClient;

    public CaseManagementTypeApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CaseManagementTypeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CaseTypeResponse createCaseType(CaseTypeCreateRequest body) throws ApiException {
        return this.createCaseTypeWithHttpInfo(body).getData();
    }

    public CompletableFuture<CaseTypeResponse> createCaseTypeAsync(CaseTypeCreateRequest body) {
        return this.createCaseTypeWithHttpInfoAsync(body).thenApply(response -> (CaseTypeResponse)response.getData());
    }

    public ApiResponse<CaseTypeResponse> createCaseTypeWithHttpInfo(CaseTypeCreateRequest body) throws ApiException {
        CaseTypeCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCaseType");
        }
        String localVarPath = "/api/v2/cases/types";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementTypeApi.createCaseType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseTypeResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseTypeResponse>> createCaseTypeWithHttpInfoAsync(CaseTypeCreateRequest body) {
        Invocation.Builder builder;
        CaseTypeCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CaseTypeResponse>> result = new CompletableFuture<ApiResponse<CaseTypeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCaseType"));
            return result;
        }
        String localVarPath = "/api/v2/cases/types";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementTypeApi.createCaseType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseTypeResponse>> result = new CompletableFuture<ApiResponse<CaseTypeResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseTypeResponse>(){});
    }

    public void deleteCaseType(String caseTypeId) throws ApiException {
        this.deleteCaseTypeWithHttpInfo(caseTypeId);
    }

    public CompletableFuture<Void> deleteCaseTypeAsync(String caseTypeId) {
        return this.deleteCaseTypeWithHttpInfoAsync(caseTypeId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCaseTypeWithHttpInfo(String caseTypeId) throws ApiException {
        Object localVarPostBody = null;
        if (caseTypeId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseTypeId' when calling deleteCaseType");
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementTypeApi.deleteCaseType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCaseTypeWithHttpInfoAsync(String caseTypeId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (caseTypeId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseTypeId' when calling deleteCaseType"));
            return result;
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementTypeApi.deleteCaseType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CaseTypesResponse getAllCaseTypes() throws ApiException {
        return this.getAllCaseTypesWithHttpInfo().getData();
    }

    public CompletableFuture<CaseTypesResponse> getAllCaseTypesAsync() {
        return this.getAllCaseTypesWithHttpInfoAsync().thenApply(response -> (CaseTypesResponse)response.getData());
    }

    public ApiResponse<CaseTypesResponse> getAllCaseTypesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cases/types";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementTypeApi.getAllCaseTypes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseTypesResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseTypesResponse>> getAllCaseTypesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cases/types";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementTypeApi.getAllCaseTypes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseTypesResponse>> result = new CompletableFuture<ApiResponse<CaseTypesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseTypesResponse>(){});
    }
}

