/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CustomAttributeConfigCreateRequest;
import com.datadog.api.client.v2.model.CustomAttributeConfigResponse;
import com.datadog.api.client.v2.model.CustomAttributeConfigsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class CaseManagementAttributeApi {
    private ApiClient apiClient;

    public CaseManagementAttributeApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CaseManagementAttributeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CustomAttributeConfigResponse createCustomAttributeConfig(String caseTypeId, CustomAttributeConfigCreateRequest body) throws ApiException {
        return this.createCustomAttributeConfigWithHttpInfo(caseTypeId, body).getData();
    }

    public CompletableFuture<CustomAttributeConfigResponse> createCustomAttributeConfigAsync(String caseTypeId, CustomAttributeConfigCreateRequest body) {
        return this.createCustomAttributeConfigWithHttpInfoAsync(caseTypeId, body).thenApply(response -> (CustomAttributeConfigResponse)response.getData());
    }

    public ApiResponse<CustomAttributeConfigResponse> createCustomAttributeConfigWithHttpInfo(String caseTypeId, CustomAttributeConfigCreateRequest body) throws ApiException {
        CustomAttributeConfigCreateRequest localVarPostBody = body;
        if (caseTypeId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseTypeId' when calling createCustomAttributeConfig");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomAttributeConfig");
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}/custom_attributes".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.createCustomAttributeConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomAttributeConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomAttributeConfigResponse>> createCustomAttributeConfigWithHttpInfoAsync(String caseTypeId, CustomAttributeConfigCreateRequest body) {
        Invocation.Builder builder;
        CustomAttributeConfigCreateRequest localVarPostBody = body;
        if (caseTypeId == null) {
            CompletableFuture<ApiResponse<CustomAttributeConfigResponse>> result = new CompletableFuture<ApiResponse<CustomAttributeConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseTypeId' when calling createCustomAttributeConfig"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CustomAttributeConfigResponse>> result = new CompletableFuture<ApiResponse<CustomAttributeConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCustomAttributeConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}/custom_attributes".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.createCustomAttributeConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomAttributeConfigResponse>> result = new CompletableFuture<ApiResponse<CustomAttributeConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomAttributeConfigResponse>(){});
    }

    public void deleteCustomAttributeConfig(String caseTypeId, String customAttributeId) throws ApiException {
        this.deleteCustomAttributeConfigWithHttpInfo(caseTypeId, customAttributeId);
    }

    public CompletableFuture<Void> deleteCustomAttributeConfigAsync(String caseTypeId, String customAttributeId) {
        return this.deleteCustomAttributeConfigWithHttpInfoAsync(caseTypeId, customAttributeId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCustomAttributeConfigWithHttpInfo(String caseTypeId, String customAttributeId) throws ApiException {
        Object localVarPostBody = null;
        if (caseTypeId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseTypeId' when calling deleteCustomAttributeConfig");
        }
        if (customAttributeId == null) {
            throw new ApiException(400, "Missing the required parameter 'customAttributeId' when calling deleteCustomAttributeConfig");
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}/custom_attributes/{custom_attribute_id}".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString())).replaceAll("\\{custom_attribute_id\\}", this.apiClient.escapeString(customAttributeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.deleteCustomAttributeConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCustomAttributeConfigWithHttpInfoAsync(String caseTypeId, String customAttributeId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (caseTypeId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseTypeId' when calling deleteCustomAttributeConfig"));
            return result;
        }
        if (customAttributeId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customAttributeId' when calling deleteCustomAttributeConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}/custom_attributes/{custom_attribute_id}".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString())).replaceAll("\\{custom_attribute_id\\}", this.apiClient.escapeString(customAttributeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.deleteCustomAttributeConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CustomAttributeConfigsResponse getAllCustomAttributeConfigsByCaseType(String caseTypeId) throws ApiException {
        return this.getAllCustomAttributeConfigsByCaseTypeWithHttpInfo(caseTypeId).getData();
    }

    public CompletableFuture<CustomAttributeConfigsResponse> getAllCustomAttributeConfigsByCaseTypeAsync(String caseTypeId) {
        return this.getAllCustomAttributeConfigsByCaseTypeWithHttpInfoAsync(caseTypeId).thenApply(response -> (CustomAttributeConfigsResponse)response.getData());
    }

    public ApiResponse<CustomAttributeConfigsResponse> getAllCustomAttributeConfigsByCaseTypeWithHttpInfo(String caseTypeId) throws ApiException {
        Object localVarPostBody = null;
        if (caseTypeId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseTypeId' when calling getAllCustomAttributeConfigsByCaseType");
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}/custom_attributes".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.getAllCustomAttributeConfigsByCaseType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomAttributeConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>> getAllCustomAttributeConfigsByCaseTypeWithHttpInfoAsync(String caseTypeId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (caseTypeId == null) {
            CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>> result = new CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseTypeId' when calling getAllCustomAttributeConfigsByCaseType"));
            return result;
        }
        String localVarPath = "/api/v2/cases/types/{case_type_id}/custom_attributes".replaceAll("\\{case_type_id\\}", this.apiClient.escapeString(caseTypeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.getAllCustomAttributeConfigsByCaseType", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>> result = new CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomAttributeConfigsResponse>(){});
    }

    public CustomAttributeConfigsResponse getAllCustomAttributes() throws ApiException {
        return this.getAllCustomAttributesWithHttpInfo().getData();
    }

    public CompletableFuture<CustomAttributeConfigsResponse> getAllCustomAttributesAsync() {
        return this.getAllCustomAttributesWithHttpInfoAsync().thenApply(response -> (CustomAttributeConfigsResponse)response.getData());
    }

    public ApiResponse<CustomAttributeConfigsResponse> getAllCustomAttributesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cases/types/custom_attributes";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.getAllCustomAttributes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomAttributeConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>> getAllCustomAttributesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cases/types/custom_attributes";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementAttributeApi.getAllCustomAttributes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>> result = new CompletableFuture<ApiResponse<CustomAttributeConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomAttributeConfigsResponse>(){});
    }
}

