/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CaseDataType;
import com.datadog.api.client.v2.model.CreateCaseRequestDataAttributes;
import com.datadog.api.client.v2.model.CreateCaseRequestDataRelationships;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class CreateCaseRequestData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private CreateCaseRequestDataAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private CreateCaseRequestDataRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CaseDataType type = CaseDataType.CASES;
    private Map<String, Object> additionalProperties;

    public CreateCaseRequestData() {
    }

    @JsonCreator
    public CreateCaseRequestData(@JsonProperty(required=true, value="type") CaseDataType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public CreateCaseRequestData attributes(CreateCaseRequestDataAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreateCaseRequestDataAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(CreateCaseRequestDataAttributes attributes) {
        this.attributes = attributes;
    }

    public CreateCaseRequestData relationships(CreateCaseRequestDataRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreateCaseRequestDataRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(CreateCaseRequestDataRelationships relationships) {
        this.relationships = relationships;
    }

    public CreateCaseRequestData type(CaseDataType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CaseDataType getType() {
        return this.type;
    }

    public void setType(CaseDataType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public CreateCaseRequestData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCaseRequestData createCaseRequestData = (CreateCaseRequestData)o;
        return Objects.equals(this.attributes, createCaseRequestData.attributes) && Objects.equals(this.relationships, createCaseRequestData.relationships) && Objects.equals(this.type, createCaseRequestData.type) && Objects.equals(this.additionalProperties, createCaseRequestData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCaseRequestData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

