/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CaseInsightsItems;
import com.datadog.api.client.v2.model.FindingJiraIssue;
import com.datadog.api.client.v2.model.RelationshipToUser;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"archived_at", "assigned_to", "attributes", "closed_at", "created_at", "creation_source", "description", "due_date", "insights", "jira_issue", "key", "modified_at", "priority", "status", "status_group", "status_name", "title", "type"})
public class FindingCaseResponseDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ARCHIVED_AT = "archived_at";
    private OffsetDateTime archivedAt;
    public static final String JSON_PROPERTY_ASSIGNED_TO = "assigned_to";
    private RelationshipToUser assignedTo;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, List<String>> attributes = null;
    public static final String JSON_PROPERTY_CLOSED_AT = "closed_at";
    private OffsetDateTime closedAt;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_CREATION_SOURCE = "creation_source";
    private String creationSource;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DUE_DATE = "due_date";
    private String dueDate;
    public static final String JSON_PROPERTY_INSIGHTS = "insights";
    private List<CaseInsightsItems> insights = null;
    public static final String JSON_PROPERTY_JIRA_ISSUE = "jira_issue";
    private FindingJiraIssue jiraIssue;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private String priority;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_STATUS_GROUP = "status_group";
    private String statusGroup;
    public static final String JSON_PROPERTY_STATUS_NAME = "status_name";
    private String statusName;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    private Map<String, Object> additionalProperties;

    public FindingCaseResponseDataAttributes archivedAt(OffsetDateTime archivedAt) {
        this.archivedAt = archivedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="archived_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getArchivedAt() {
        return this.archivedAt;
    }

    public void setArchivedAt(OffsetDateTime archivedAt) {
        this.archivedAt = archivedAt;
    }

    public FindingCaseResponseDataAttributes assignedTo(RelationshipToUser assignedTo) {
        this.assignedTo = assignedTo;
        this.unparsed |= assignedTo.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="assigned_to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipToUser getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(RelationshipToUser assignedTo) {
        this.assignedTo = assignedTo;
    }

    public FindingCaseResponseDataAttributes attributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
        return this;
    }

    public FindingCaseResponseDataAttributes putAttributesItem(String key, List<String> attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, List<String>>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public FindingCaseResponseDataAttributes closedAt(OffsetDateTime closedAt) {
        this.closedAt = closedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(OffsetDateTime closedAt) {
        this.closedAt = closedAt;
    }

    public FindingCaseResponseDataAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public FindingCaseResponseDataAttributes creationSource(String creationSource) {
        this.creationSource = creationSource;
        return this;
    }

    @Nullable
    @JsonProperty(value="creation_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreationSource() {
        return this.creationSource;
    }

    public void setCreationSource(String creationSource) {
        this.creationSource = creationSource;
    }

    public FindingCaseResponseDataAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FindingCaseResponseDataAttributes dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="due_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public FindingCaseResponseDataAttributes insights(List<CaseInsightsItems> insights) {
        this.insights = insights;
        for (CaseInsightsItems item : insights) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FindingCaseResponseDataAttributes addInsightsItem(CaseInsightsItems insightsItem) {
        if (this.insights == null) {
            this.insights = new ArrayList<CaseInsightsItems>();
        }
        this.insights.add(insightsItem);
        this.unparsed |= insightsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="insights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CaseInsightsItems> getInsights() {
        return this.insights;
    }

    public void setInsights(List<CaseInsightsItems> insights) {
        this.insights = insights;
    }

    public FindingCaseResponseDataAttributes jiraIssue(FindingJiraIssue jiraIssue) {
        this.jiraIssue = jiraIssue;
        this.unparsed |= jiraIssue.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="jira_issue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FindingJiraIssue getJiraIssue() {
        return this.jiraIssue;
    }

    public void setJiraIssue(FindingJiraIssue jiraIssue) {
        this.jiraIssue = jiraIssue;
    }

    public FindingCaseResponseDataAttributes key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public FindingCaseResponseDataAttributes modifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public FindingCaseResponseDataAttributes priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public FindingCaseResponseDataAttributes status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FindingCaseResponseDataAttributes statusGroup(String statusGroup) {
        this.statusGroup = statusGroup;
        return this;
    }

    @Nullable
    @JsonProperty(value="status_group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatusGroup() {
        return this.statusGroup;
    }

    public void setStatusGroup(String statusGroup) {
        this.statusGroup = statusGroup;
    }

    public FindingCaseResponseDataAttributes statusName(String statusName) {
        this.statusName = statusName;
        return this;
    }

    @Nullable
    @JsonProperty(value="status_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatusName() {
        return this.statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public FindingCaseResponseDataAttributes title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public FindingCaseResponseDataAttributes type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnySetter
    public FindingCaseResponseDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindingCaseResponseDataAttributes findingCaseResponseDataAttributes = (FindingCaseResponseDataAttributes)o;
        return Objects.equals(this.archivedAt, findingCaseResponseDataAttributes.archivedAt) && Objects.equals(this.assignedTo, findingCaseResponseDataAttributes.assignedTo) && Objects.equals(this.attributes, findingCaseResponseDataAttributes.attributes) && Objects.equals(this.closedAt, findingCaseResponseDataAttributes.closedAt) && Objects.equals(this.createdAt, findingCaseResponseDataAttributes.createdAt) && Objects.equals(this.creationSource, findingCaseResponseDataAttributes.creationSource) && Objects.equals(this.description, findingCaseResponseDataAttributes.description) && Objects.equals(this.dueDate, findingCaseResponseDataAttributes.dueDate) && Objects.equals(this.insights, findingCaseResponseDataAttributes.insights) && Objects.equals(this.jiraIssue, findingCaseResponseDataAttributes.jiraIssue) && Objects.equals(this.key, findingCaseResponseDataAttributes.key) && Objects.equals(this.modifiedAt, findingCaseResponseDataAttributes.modifiedAt) && Objects.equals(this.priority, findingCaseResponseDataAttributes.priority) && Objects.equals(this.status, findingCaseResponseDataAttributes.status) && Objects.equals(this.statusGroup, findingCaseResponseDataAttributes.statusGroup) && Objects.equals(this.statusName, findingCaseResponseDataAttributes.statusName) && Objects.equals(this.title, findingCaseResponseDataAttributes.title) && Objects.equals(this.type, findingCaseResponseDataAttributes.type) && Objects.equals(this.additionalProperties, findingCaseResponseDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.archivedAt, this.assignedTo, this.attributes, this.closedAt, this.createdAt, this.creationSource, this.description, this.dueDate, this.insights, this.jiraIssue, this.key, this.modifiedAt, this.priority, this.status, this.statusGroup, this.statusName, this.title, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FindingCaseResponseDataAttributes {\n");
        sb.append("    archivedAt: ").append(this.toIndentedString(this.archivedAt)).append("\n");
        sb.append("    assignedTo: ").append(this.toIndentedString(this.assignedTo)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    closedAt: ").append(this.toIndentedString(this.closedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creationSource: ").append(this.toIndentedString(this.creationSource)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    insights: ").append(this.toIndentedString(this.insights)).append("\n");
        sb.append("    jiraIssue: ").append(this.toIndentedString(this.jiraIssue)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusGroup: ").append(this.toIndentedString(this.statusGroup)).append("\n");
        sb.append("    statusName: ").append(this.toIndentedString(this.statusName)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

