/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AwsOnDemandCreateRequest;
import com.datadog.api.client.v2.model.AwsOnDemandListResponse;
import com.datadog.api.client.v2.model.AwsOnDemandResponse;
import com.datadog.api.client.v2.model.AwsScanOptionsCreateRequest;
import com.datadog.api.client.v2.model.AwsScanOptionsListResponse;
import com.datadog.api.client.v2.model.AwsScanOptionsResponse;
import com.datadog.api.client.v2.model.AwsScanOptionsUpdateRequest;
import com.datadog.api.client.v2.model.AzureScanOptions;
import com.datadog.api.client.v2.model.AzureScanOptionsArray;
import com.datadog.api.client.v2.model.AzureScanOptionsInputUpdate;
import com.datadog.api.client.v2.model.GcpScanOptions;
import com.datadog.api.client.v2.model.GcpScanOptionsArray;
import com.datadog.api.client.v2.model.GcpScanOptionsInputUpdate;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class AgentlessScanningApi {
    private ApiClient apiClient;

    public AgentlessScanningApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AgentlessScanningApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AwsOnDemandResponse createAwsOnDemandTask(AwsOnDemandCreateRequest body) throws ApiException {
        return this.createAwsOnDemandTaskWithHttpInfo(body).getData();
    }

    public CompletableFuture<AwsOnDemandResponse> createAwsOnDemandTaskAsync(AwsOnDemandCreateRequest body) {
        return this.createAwsOnDemandTaskWithHttpInfoAsync(body).thenApply(response -> (AwsOnDemandResponse)response.getData());
    }

    public ApiResponse<AwsOnDemandResponse> createAwsOnDemandTaskWithHttpInfo(AwsOnDemandCreateRequest body) throws ApiException {
        AwsOnDemandCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAwsOnDemandTask");
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsOnDemandResponse>> createAwsOnDemandTaskWithHttpInfoAsync(AwsOnDemandCreateRequest body) {
        Invocation.Builder builder;
        AwsOnDemandCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAwsOnDemandTask"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public AwsScanOptionsResponse createAwsScanOptions(AwsScanOptionsCreateRequest body) throws ApiException {
        return this.createAwsScanOptionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<AwsScanOptionsResponse> createAwsScanOptionsAsync(AwsScanOptionsCreateRequest body) {
        return this.createAwsScanOptionsWithHttpInfoAsync(body).thenApply(response -> (AwsScanOptionsResponse)response.getData());
    }

    public ApiResponse<AwsScanOptionsResponse> createAwsScanOptionsWithHttpInfo(AwsScanOptionsCreateRequest body) throws ApiException {
        AwsScanOptionsCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsScanOptionsResponse>> createAwsScanOptionsWithHttpInfoAsync(AwsScanOptionsCreateRequest body) {
        Invocation.Builder builder;
        AwsScanOptionsCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public AzureScanOptions createAzureScanOptions(AzureScanOptions body) throws ApiException {
        return this.createAzureScanOptionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<AzureScanOptions> createAzureScanOptionsAsync(AzureScanOptions body) {
        return this.createAzureScanOptionsWithHttpInfoAsync(body).thenApply(response -> (AzureScanOptions)response.getData());
    }

    public ApiResponse<AzureScanOptions> createAzureScanOptionsWithHttpInfo(AzureScanOptions body) throws ApiException {
        AzureScanOptions localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAzureScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptions>(){});
    }

    public CompletableFuture<ApiResponse<AzureScanOptions>> createAzureScanOptionsWithHttpInfoAsync(AzureScanOptions body) {
        Invocation.Builder builder;
        AzureScanOptions localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AzureScanOptions>> result = new CompletableFuture<ApiResponse<AzureScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAzureScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureScanOptions>> result = new CompletableFuture<ApiResponse<AzureScanOptions>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptions>(){});
    }

    public GcpScanOptions createGcpScanOptions(GcpScanOptions body) throws ApiException {
        return this.createGcpScanOptionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<GcpScanOptions> createGcpScanOptionsAsync(GcpScanOptions body) {
        return this.createGcpScanOptionsWithHttpInfoAsync(body).thenApply(response -> (GcpScanOptions)response.getData());
    }

    public ApiResponse<GcpScanOptions> createGcpScanOptionsWithHttpInfo(GcpScanOptions body) throws ApiException {
        GcpScanOptions localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGcpScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptions>(){});
    }

    public CompletableFuture<ApiResponse<GcpScanOptions>> createGcpScanOptionsWithHttpInfoAsync(GcpScanOptions body) {
        Invocation.Builder builder;
        GcpScanOptions localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<GcpScanOptions>> result = new CompletableFuture<ApiResponse<GcpScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createGcpScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GcpScanOptions>> result = new CompletableFuture<ApiResponse<GcpScanOptions>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptions>(){});
    }

    public void deleteAwsScanOptions(String accountId) throws ApiException {
        this.deleteAwsScanOptionsWithHttpInfo(accountId);
    }

    public CompletableFuture<Void> deleteAwsScanOptionsAsync(String accountId) {
        return this.deleteAwsScanOptionsWithHttpInfoAsync(accountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteAwsScanOptionsWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteAwsScanOptionsWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteAzureScanOptions(String subscriptionId) throws ApiException {
        this.deleteAzureScanOptionsWithHttpInfo(subscriptionId);
    }

    public CompletableFuture<Void> deleteAzureScanOptionsAsync(String subscriptionId) {
        return this.deleteAzureScanOptionsWithHttpInfoAsync(subscriptionId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteAzureScanOptionsWithHttpInfo(String subscriptionId) throws ApiException {
        Object localVarPostBody = null;
        if (subscriptionId == null) {
            throw new ApiException(400, "Missing the required parameter 'subscriptionId' when calling deleteAzureScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure/{subscription_id}".replaceAll("\\{subscription_id\\}", this.apiClient.escapeString(subscriptionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteAzureScanOptionsWithHttpInfoAsync(String subscriptionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (subscriptionId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'subscriptionId' when calling deleteAzureScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure/{subscription_id}".replaceAll("\\{subscription_id\\}", this.apiClient.escapeString(subscriptionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteGcpScanOptions(String projectId) throws ApiException {
        this.deleteGcpScanOptionsWithHttpInfo(projectId);
    }

    public CompletableFuture<Void> deleteGcpScanOptionsAsync(String projectId) {
        return this.deleteGcpScanOptionsWithHttpInfoAsync(projectId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteGcpScanOptionsWithHttpInfo(String projectId) throws ApiException {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling deleteGcpScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteGcpScanOptionsWithHttpInfoAsync(String projectId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (projectId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'projectId' when calling deleteGcpScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public AwsOnDemandResponse getAwsOnDemandTask(String taskId) throws ApiException {
        return this.getAwsOnDemandTaskWithHttpInfo(taskId).getData();
    }

    public CompletableFuture<AwsOnDemandResponse> getAwsOnDemandTaskAsync(String taskId) {
        return this.getAwsOnDemandTaskWithHttpInfoAsync(taskId).thenApply(response -> (AwsOnDemandResponse)response.getData());
    }

    public ApiResponse<AwsOnDemandResponse> getAwsOnDemandTaskWithHttpInfo(String taskId) throws ApiException {
        Object localVarPostBody = null;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling getAwsOnDemandTask");
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws/{task_id}".replaceAll("\\{task_id\\}", this.apiClient.escapeString(taskId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsOnDemandResponse>> getAwsOnDemandTaskWithHttpInfoAsync(String taskId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (taskId == null) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'taskId' when calling getAwsOnDemandTask"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws/{task_id}".replaceAll("\\{task_id\\}", this.apiClient.escapeString(taskId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public AwsScanOptionsResponse getAwsScanOptions(String accountId) throws ApiException {
        return this.getAwsScanOptionsWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<AwsScanOptionsResponse> getAwsScanOptionsAsync(String accountId) {
        return this.getAwsScanOptionsWithHttpInfoAsync(accountId).thenApply(response -> (AwsScanOptionsResponse)response.getData());
    }

    public ApiResponse<AwsScanOptionsResponse> getAwsScanOptionsWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsScanOptionsResponse>> getAwsScanOptionsWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public AzureScanOptions getAzureScanOptions(String subscriptionId) throws ApiException {
        return this.getAzureScanOptionsWithHttpInfo(subscriptionId).getData();
    }

    public CompletableFuture<AzureScanOptions> getAzureScanOptionsAsync(String subscriptionId) {
        return this.getAzureScanOptionsWithHttpInfoAsync(subscriptionId).thenApply(response -> (AzureScanOptions)response.getData());
    }

    public ApiResponse<AzureScanOptions> getAzureScanOptionsWithHttpInfo(String subscriptionId) throws ApiException {
        Object localVarPostBody = null;
        if (subscriptionId == null) {
            throw new ApiException(400, "Missing the required parameter 'subscriptionId' when calling getAzureScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure/{subscription_id}".replaceAll("\\{subscription_id\\}", this.apiClient.escapeString(subscriptionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptions>(){});
    }

    public CompletableFuture<ApiResponse<AzureScanOptions>> getAzureScanOptionsWithHttpInfoAsync(String subscriptionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (subscriptionId == null) {
            CompletableFuture<ApiResponse<AzureScanOptions>> result = new CompletableFuture<ApiResponse<AzureScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'subscriptionId' when calling getAzureScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure/{subscription_id}".replaceAll("\\{subscription_id\\}", this.apiClient.escapeString(subscriptionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureScanOptions>> result = new CompletableFuture<ApiResponse<AzureScanOptions>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptions>(){});
    }

    public GcpScanOptions getGcpScanOptions(String projectId) throws ApiException {
        return this.getGcpScanOptionsWithHttpInfo(projectId).getData();
    }

    public CompletableFuture<GcpScanOptions> getGcpScanOptionsAsync(String projectId) {
        return this.getGcpScanOptionsWithHttpInfoAsync(projectId).thenApply(response -> (GcpScanOptions)response.getData());
    }

    public ApiResponse<GcpScanOptions> getGcpScanOptionsWithHttpInfo(String projectId) throws ApiException {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getGcpScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptions>(){});
    }

    public CompletableFuture<ApiResponse<GcpScanOptions>> getGcpScanOptionsWithHttpInfoAsync(String projectId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (projectId == null) {
            CompletableFuture<ApiResponse<GcpScanOptions>> result = new CompletableFuture<ApiResponse<GcpScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'projectId' when calling getGcpScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GcpScanOptions>> result = new CompletableFuture<ApiResponse<GcpScanOptions>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptions>(){});
    }

    public AwsOnDemandListResponse listAwsOnDemandTasks() throws ApiException {
        return this.listAwsOnDemandTasksWithHttpInfo().getData();
    }

    public CompletableFuture<AwsOnDemandListResponse> listAwsOnDemandTasksAsync() {
        return this.listAwsOnDemandTasksWithHttpInfoAsync().thenApply(response -> (AwsOnDemandListResponse)response.getData());
    }

    public ApiResponse<AwsOnDemandListResponse> listAwsOnDemandTasksWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsOnDemandTasks", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandListResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsOnDemandListResponse>> listAwsOnDemandTasksWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsOnDemandTasks", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsOnDemandListResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandListResponse>(){});
    }

    public AwsScanOptionsListResponse listAwsScanOptions() throws ApiException {
        return this.listAwsScanOptionsWithHttpInfo().getData();
    }

    public CompletableFuture<AwsScanOptionsListResponse> listAwsScanOptionsAsync() {
        return this.listAwsScanOptionsWithHttpInfoAsync().thenApply(response -> (AwsScanOptionsListResponse)response.getData());
    }

    public ApiResponse<AwsScanOptionsListResponse> listAwsScanOptionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsScanOptionsListResponse>> listAwsScanOptionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsScanOptionsListResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsListResponse>(){});
    }

    public AzureScanOptionsArray listAzureScanOptions() throws ApiException {
        return this.listAzureScanOptionsWithHttpInfo().getData();
    }

    public CompletableFuture<AzureScanOptionsArray> listAzureScanOptionsAsync() {
        return this.listAzureScanOptionsWithHttpInfoAsync().thenApply(response -> (AzureScanOptionsArray)response.getData());
    }

    public ApiResponse<AzureScanOptionsArray> listAzureScanOptionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptionsArray>(){});
    }

    public CompletableFuture<ApiResponse<AzureScanOptionsArray>> listAzureScanOptionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureScanOptionsArray>> result = new CompletableFuture<ApiResponse<AzureScanOptionsArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptionsArray>(){});
    }

    public GcpScanOptionsArray listGcpScanOptions() throws ApiException {
        return this.listGcpScanOptionsWithHttpInfo().getData();
    }

    public CompletableFuture<GcpScanOptionsArray> listGcpScanOptionsAsync() {
        return this.listGcpScanOptionsWithHttpInfoAsync().thenApply(response -> (GcpScanOptionsArray)response.getData());
    }

    public ApiResponse<GcpScanOptionsArray> listGcpScanOptionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptionsArray>(){});
    }

    public CompletableFuture<ApiResponse<GcpScanOptionsArray>> listGcpScanOptionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GcpScanOptionsArray>> result = new CompletableFuture<ApiResponse<GcpScanOptionsArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptionsArray>(){});
    }

    public void updateAwsScanOptions(String accountId, AwsScanOptionsUpdateRequest body) throws ApiException {
        this.updateAwsScanOptionsWithHttpInfo(accountId, body);
    }

    public CompletableFuture<Void> updateAwsScanOptionsAsync(String accountId, AwsScanOptionsUpdateRequest body) {
        return this.updateAwsScanOptionsWithHttpInfoAsync(accountId, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> updateAwsScanOptionsWithHttpInfo(String accountId, AwsScanOptionsUpdateRequest body) throws ApiException {
        AwsScanOptionsUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateAwsScanOptions");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> updateAwsScanOptionsWithHttpInfoAsync(String accountId, AwsScanOptionsUpdateRequest body) {
        Invocation.Builder builder;
        AwsScanOptionsUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateAwsScanOptions"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public AzureScanOptions updateAzureScanOptions(String subscriptionId, AzureScanOptionsInputUpdate body) throws ApiException {
        return this.updateAzureScanOptionsWithHttpInfo(subscriptionId, body).getData();
    }

    public CompletableFuture<AzureScanOptions> updateAzureScanOptionsAsync(String subscriptionId, AzureScanOptionsInputUpdate body) {
        return this.updateAzureScanOptionsWithHttpInfoAsync(subscriptionId, body).thenApply(response -> (AzureScanOptions)response.getData());
    }

    public ApiResponse<AzureScanOptions> updateAzureScanOptionsWithHttpInfo(String subscriptionId, AzureScanOptionsInputUpdate body) throws ApiException {
        AzureScanOptionsInputUpdate localVarPostBody = body;
        if (subscriptionId == null) {
            throw new ApiException(400, "Missing the required parameter 'subscriptionId' when calling updateAzureScanOptions");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAzureScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure/{subscription_id}".replaceAll("\\{subscription_id\\}", this.apiClient.escapeString(subscriptionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptions>(){});
    }

    public CompletableFuture<ApiResponse<AzureScanOptions>> updateAzureScanOptionsWithHttpInfoAsync(String subscriptionId, AzureScanOptionsInputUpdate body) {
        Invocation.Builder builder;
        AzureScanOptionsInputUpdate localVarPostBody = body;
        if (subscriptionId == null) {
            CompletableFuture<ApiResponse<AzureScanOptions>> result = new CompletableFuture<ApiResponse<AzureScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'subscriptionId' when calling updateAzureScanOptions"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AzureScanOptions>> result = new CompletableFuture<ApiResponse<AzureScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAzureScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/azure/{subscription_id}".replaceAll("\\{subscription_id\\}", this.apiClient.escapeString(subscriptionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateAzureScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureScanOptions>> result = new CompletableFuture<ApiResponse<AzureScanOptions>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureScanOptions>(){});
    }

    public GcpScanOptions updateGcpScanOptions(String projectId, GcpScanOptionsInputUpdate body) throws ApiException {
        return this.updateGcpScanOptionsWithHttpInfo(projectId, body).getData();
    }

    public CompletableFuture<GcpScanOptions> updateGcpScanOptionsAsync(String projectId, GcpScanOptionsInputUpdate body) {
        return this.updateGcpScanOptionsWithHttpInfoAsync(projectId, body).thenApply(response -> (GcpScanOptions)response.getData());
    }

    public ApiResponse<GcpScanOptions> updateGcpScanOptionsWithHttpInfo(String projectId, GcpScanOptionsInputUpdate body) throws ApiException {
        GcpScanOptionsInputUpdate localVarPostBody = body;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling updateGcpScanOptions");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateGcpScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptions>(){});
    }

    public CompletableFuture<ApiResponse<GcpScanOptions>> updateGcpScanOptionsWithHttpInfoAsync(String projectId, GcpScanOptionsInputUpdate body) {
        Invocation.Builder builder;
        GcpScanOptionsInputUpdate localVarPostBody = body;
        if (projectId == null) {
            CompletableFuture<ApiResponse<GcpScanOptions>> result = new CompletableFuture<ApiResponse<GcpScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'projectId' when calling updateGcpScanOptions"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<GcpScanOptions>> result = new CompletableFuture<ApiResponse<GcpScanOptions>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateGcpScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/gcp/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateGcpScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GcpScanOptions>> result = new CompletableFuture<ApiResponse<GcpScanOptions>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GcpScanOptions>(){});
    }
}

