/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetDeploymentPackage;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"filter_query", "target_packages"})
public class FleetDeploymentPackageUpgradeAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER_QUERY = "filter_query";
    private String filterQuery;
    public static final String JSON_PROPERTY_TARGET_PACKAGES = "target_packages";
    private List<FleetDeploymentPackage> targetPackages = new ArrayList<FleetDeploymentPackage>();
    private Map<String, Object> additionalProperties;

    public FleetDeploymentPackageUpgradeAttributes() {
    }

    @JsonCreator
    public FleetDeploymentPackageUpgradeAttributes(@JsonProperty(required=true, value="target_packages") List<FleetDeploymentPackage> targetPackages) {
        this.targetPackages = targetPackages;
    }

    public FleetDeploymentPackageUpgradeAttributes filterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilterQuery() {
        return this.filterQuery;
    }

    public void setFilterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
    }

    public FleetDeploymentPackageUpgradeAttributes targetPackages(List<FleetDeploymentPackage> targetPackages) {
        this.targetPackages = targetPackages;
        for (FleetDeploymentPackage item : targetPackages) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetDeploymentPackageUpgradeAttributes addTargetPackagesItem(FleetDeploymentPackage targetPackagesItem) {
        this.targetPackages.add(targetPackagesItem);
        this.unparsed |= targetPackagesItem.unparsed;
        return this;
    }

    @JsonProperty(value="target_packages")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FleetDeploymentPackage> getTargetPackages() {
        return this.targetPackages;
    }

    public void setTargetPackages(List<FleetDeploymentPackage> targetPackages) {
        this.targetPackages = targetPackages;
    }

    @JsonAnySetter
    public FleetDeploymentPackageUpgradeAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetDeploymentPackageUpgradeAttributes fleetDeploymentPackageUpgradeAttributes = (FleetDeploymentPackageUpgradeAttributes)o;
        return Objects.equals(this.filterQuery, fleetDeploymentPackageUpgradeAttributes.filterQuery) && Objects.equals(this.targetPackages, fleetDeploymentPackageUpgradeAttributes.targetPackages) && Objects.equals(this.additionalProperties, fleetDeploymentPackageUpgradeAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.filterQuery, this.targetPackages, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetDeploymentPackageUpgradeAttributes {\n");
        sb.append("    filterQuery: ").append(this.toIndentedString(this.filterQuery)).append("\n");
        sb.append("    targetPackages: ").append(this.toIndentedString(this.targetPackages)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

