/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.FlakyTest;
import com.datadog.api.client.v2.model.FlakyTestsSearchPageOptions;
import com.datadog.api.client.v2.model.FlakyTestsSearchRequest;
import com.datadog.api.client.v2.model.FlakyTestsSearchRequestAttributes;
import com.datadog.api.client.v2.model.FlakyTestsSearchRequestData;
import com.datadog.api.client.v2.model.FlakyTestsSearchResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class TestOptimizationApi {
    private ApiClient apiClient;

    public TestOptimizationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public TestOptimizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FlakyTestsSearchResponse searchFlakyTests() throws ApiException {
        return this.searchFlakyTestsWithHttpInfo(new SearchFlakyTestsOptionalParameters()).getData();
    }

    public CompletableFuture<FlakyTestsSearchResponse> searchFlakyTestsAsync() {
        return this.searchFlakyTestsWithHttpInfoAsync(new SearchFlakyTestsOptionalParameters()).thenApply(response -> (FlakyTestsSearchResponse)response.getData());
    }

    public FlakyTestsSearchResponse searchFlakyTests(SearchFlakyTestsOptionalParameters parameters) throws ApiException {
        return this.searchFlakyTestsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<FlakyTestsSearchResponse> searchFlakyTestsAsync(SearchFlakyTestsOptionalParameters parameters) {
        return this.searchFlakyTestsWithHttpInfoAsync(parameters).thenApply(response -> (FlakyTestsSearchResponse)response.getData());
    }

    public PaginationIterable<FlakyTest> searchFlakyTestsWithPagination() {
        SearchFlakyTestsOptionalParameters parameters = new SearchFlakyTestsOptionalParameters();
        return this.searchFlakyTestsWithPagination(parameters);
    }

    public PaginationIterable<FlakyTest> searchFlakyTestsWithPagination(SearchFlakyTestsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPagination.getNextPage";
        String valueSetterPath = "body.getData.getAttributes.getPage.setCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.body == null) {
            parameters.body(new FlakyTestsSearchRequest());
        }
        if (parameters.body.getData() == null) {
            parameters.body.setData(new FlakyTestsSearchRequestData());
        }
        if (parameters.body.getData().getAttributes() == null) {
            parameters.body.getData().setAttributes(new FlakyTestsSearchRequestAttributes());
        }
        if (parameters.body.getData().getAttributes().getPage() == null) {
            parameters.body.getData().getAttributes().setPage(new FlakyTestsSearchPageOptions());
        }
        if (parameters.body.getData().getAttributes().getPage().getLimit() == null) {
            limit = 10L;
            parameters.body.getData().getAttributes().getPage().setLimit(limit);
        } else {
            limit = parameters.body.getData().getAttributes().getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<FlakyTest> iterator = new PaginationIterable<FlakyTest>(this, "searchFlakyTests", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<FlakyTestsSearchResponse> searchFlakyTestsWithHttpInfo(SearchFlakyTestsOptionalParameters parameters) throws ApiException {
        String operationId = "searchFlakyTests";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FlakyTestsSearchRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/test/flaky-test-management/tests";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TestOptimizationApi.searchFlakyTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FlakyTestsSearchResponse>(){});
    }

    public CompletableFuture<ApiResponse<FlakyTestsSearchResponse>> searchFlakyTestsWithHttpInfoAsync(SearchFlakyTestsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "searchFlakyTests";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FlakyTestsSearchResponse>> result = new CompletableFuture<ApiResponse<FlakyTestsSearchResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FlakyTestsSearchRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/test/flaky-test-management/tests";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TestOptimizationApi.searchFlakyTests", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FlakyTestsSearchResponse>> result = new CompletableFuture<ApiResponse<FlakyTestsSearchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FlakyTestsSearchResponse>(){});
    }

    public static class SearchFlakyTestsOptionalParameters {
        private FlakyTestsSearchRequest body;

        public SearchFlakyTestsOptionalParameters body(FlakyTestsSearchRequest body) {
            this.body = body;
            return this;
        }
    }
}

