/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateConnectionRequest;
import com.datadog.api.client.v2.model.FacetInfoRequest;
import com.datadog.api.client.v2.model.FacetInfoResponse;
import com.datadog.api.client.v2.model.GetMappingResponse;
import com.datadog.api.client.v2.model.ListConnectionsResponse;
import com.datadog.api.client.v2.model.QueryAccountRequest;
import com.datadog.api.client.v2.model.QueryEventFilteredUsersRequest;
import com.datadog.api.client.v2.model.QueryResponse;
import com.datadog.api.client.v2.model.QueryUsersRequest;
import com.datadog.api.client.v2.model.UpdateConnectionRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class RumAudienceManagementApi {
    private ApiClient apiClient;

    public RumAudienceManagementApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public RumAudienceManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void createConnection(String entity, CreateConnectionRequest body) throws ApiException {
        this.createConnectionWithHttpInfo(entity, body);
    }

    public CompletableFuture<Void> createConnectionAsync(String entity, CreateConnectionRequest body) {
        return this.createConnectionWithHttpInfoAsync(entity, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> createConnectionWithHttpInfo(String entity, CreateConnectionRequest body) throws ApiException {
        String operationId = "createConnection";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateConnectionRequest localVarPostBody = body;
        if (entity == null) {
            throw new ApiException(400, "Missing the required parameter 'entity' when calling createConnection");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createConnection");
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connection".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.createConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> createConnectionWithHttpInfoAsync(String entity, CreateConnectionRequest body) {
        Invocation.Builder builder;
        String operationId = "createConnection";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateConnectionRequest localVarPostBody = body;
        if (entity == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'entity' when calling createConnection"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createConnection"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connection".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.createConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteConnection(String id, String entity) throws ApiException {
        this.deleteConnectionWithHttpInfo(id, entity);
    }

    public CompletableFuture<Void> deleteConnectionAsync(String id, String entity) {
        return this.deleteConnectionWithHttpInfoAsync(id, entity).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteConnectionWithHttpInfo(String id, String entity) throws ApiException {
        String operationId = "deleteConnection";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteConnection");
        }
        if (entity == null) {
            throw new ApiException(400, "Missing the required parameter 'entity' when calling deleteConnection");
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connection/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.deleteConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteConnectionWithHttpInfoAsync(String id, String entity) {
        Invocation.Builder builder;
        String operationId = "deleteConnection";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteConnection"));
            return result;
        }
        if (entity == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'entity' when calling deleteConnection"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connection/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.deleteConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public FacetInfoResponse getAccountFacetInfo(FacetInfoRequest body) throws ApiException {
        return this.getAccountFacetInfoWithHttpInfo(body).getData();
    }

    public CompletableFuture<FacetInfoResponse> getAccountFacetInfoAsync(FacetInfoRequest body) {
        return this.getAccountFacetInfoWithHttpInfoAsync(body).thenApply(response -> (FacetInfoResponse)response.getData());
    }

    public ApiResponse<FacetInfoResponse> getAccountFacetInfoWithHttpInfo(FacetInfoRequest body) throws ApiException {
        String operationId = "getAccountFacetInfo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FacetInfoRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling getAccountFacetInfo");
        }
        String localVarPath = "/api/v2/product-analytics/accounts/facet_info";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.getAccountFacetInfo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FacetInfoResponse>(){});
    }

    public CompletableFuture<ApiResponse<FacetInfoResponse>> getAccountFacetInfoWithHttpInfoAsync(FacetInfoRequest body) {
        Invocation.Builder builder;
        String operationId = "getAccountFacetInfo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FacetInfoResponse>> result = new CompletableFuture<ApiResponse<FacetInfoResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FacetInfoRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FacetInfoResponse>> result = new CompletableFuture<ApiResponse<FacetInfoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling getAccountFacetInfo"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/accounts/facet_info";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.getAccountFacetInfo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FacetInfoResponse>> result = new CompletableFuture<ApiResponse<FacetInfoResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FacetInfoResponse>(){});
    }

    public GetMappingResponse getMapping(String entity) throws ApiException {
        return this.getMappingWithHttpInfo(entity).getData();
    }

    public CompletableFuture<GetMappingResponse> getMappingAsync(String entity) {
        return this.getMappingWithHttpInfoAsync(entity).thenApply(response -> (GetMappingResponse)response.getData());
    }

    public ApiResponse<GetMappingResponse> getMappingWithHttpInfo(String entity) throws ApiException {
        String operationId = "getMapping";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (entity == null) {
            throw new ApiException(400, "Missing the required parameter 'entity' when calling getMapping");
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.getMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetMappingResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetMappingResponse>> getMappingWithHttpInfoAsync(String entity) {
        Invocation.Builder builder;
        String operationId = "getMapping";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetMappingResponse>> result = new CompletableFuture<ApiResponse<GetMappingResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (entity == null) {
            CompletableFuture<ApiResponse<GetMappingResponse>> result = new CompletableFuture<ApiResponse<GetMappingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'entity' when calling getMapping"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.getMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetMappingResponse>> result = new CompletableFuture<ApiResponse<GetMappingResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetMappingResponse>(){});
    }

    public FacetInfoResponse getUserFacetInfo(FacetInfoRequest body) throws ApiException {
        return this.getUserFacetInfoWithHttpInfo(body).getData();
    }

    public CompletableFuture<FacetInfoResponse> getUserFacetInfoAsync(FacetInfoRequest body) {
        return this.getUserFacetInfoWithHttpInfoAsync(body).thenApply(response -> (FacetInfoResponse)response.getData());
    }

    public ApiResponse<FacetInfoResponse> getUserFacetInfoWithHttpInfo(FacetInfoRequest body) throws ApiException {
        String operationId = "getUserFacetInfo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FacetInfoRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling getUserFacetInfo");
        }
        String localVarPath = "/api/v2/product-analytics/users/facet_info";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.getUserFacetInfo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FacetInfoResponse>(){});
    }

    public CompletableFuture<ApiResponse<FacetInfoResponse>> getUserFacetInfoWithHttpInfoAsync(FacetInfoRequest body) {
        Invocation.Builder builder;
        String operationId = "getUserFacetInfo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FacetInfoResponse>> result = new CompletableFuture<ApiResponse<FacetInfoResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FacetInfoRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FacetInfoResponse>> result = new CompletableFuture<ApiResponse<FacetInfoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling getUserFacetInfo"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/users/facet_info";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.getUserFacetInfo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FacetInfoResponse>> result = new CompletableFuture<ApiResponse<FacetInfoResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FacetInfoResponse>(){});
    }

    public ListConnectionsResponse listConnections(String entity) throws ApiException {
        return this.listConnectionsWithHttpInfo(entity).getData();
    }

    public CompletableFuture<ListConnectionsResponse> listConnectionsAsync(String entity) {
        return this.listConnectionsWithHttpInfoAsync(entity).thenApply(response -> (ListConnectionsResponse)response.getData());
    }

    public ApiResponse<ListConnectionsResponse> listConnectionsWithHttpInfo(String entity) throws ApiException {
        String operationId = "listConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (entity == null) {
            throw new ApiException(400, "Missing the required parameter 'entity' when calling listConnections");
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connections".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.listConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListConnectionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListConnectionsResponse>> listConnectionsWithHttpInfoAsync(String entity) {
        Invocation.Builder builder;
        String operationId = "listConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListConnectionsResponse>> result = new CompletableFuture<ApiResponse<ListConnectionsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (entity == null) {
            CompletableFuture<ApiResponse<ListConnectionsResponse>> result = new CompletableFuture<ApiResponse<ListConnectionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'entity' when calling listConnections"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connections".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.listConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListConnectionsResponse>> result = new CompletableFuture<ApiResponse<ListConnectionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListConnectionsResponse>(){});
    }

    public QueryResponse queryAccounts(QueryAccountRequest body) throws ApiException {
        return this.queryAccountsWithHttpInfo(body).getData();
    }

    public CompletableFuture<QueryResponse> queryAccountsAsync(QueryAccountRequest body) {
        return this.queryAccountsWithHttpInfoAsync(body).thenApply(response -> (QueryResponse)response.getData());
    }

    public ApiResponse<QueryResponse> queryAccountsWithHttpInfo(QueryAccountRequest body) throws ApiException {
        String operationId = "queryAccounts";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        QueryAccountRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling queryAccounts");
        }
        String localVarPath = "/api/v2/product-analytics/accounts/query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.queryAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<QueryResponse>(){});
    }

    public CompletableFuture<ApiResponse<QueryResponse>> queryAccountsWithHttpInfoAsync(QueryAccountRequest body) {
        Invocation.Builder builder;
        String operationId = "queryAccounts";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        QueryAccountRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling queryAccounts"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/accounts/query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.queryAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<QueryResponse>(){});
    }

    public QueryResponse queryEventFilteredUsers(QueryEventFilteredUsersRequest body) throws ApiException {
        return this.queryEventFilteredUsersWithHttpInfo(body).getData();
    }

    public CompletableFuture<QueryResponse> queryEventFilteredUsersAsync(QueryEventFilteredUsersRequest body) {
        return this.queryEventFilteredUsersWithHttpInfoAsync(body).thenApply(response -> (QueryResponse)response.getData());
    }

    public ApiResponse<QueryResponse> queryEventFilteredUsersWithHttpInfo(QueryEventFilteredUsersRequest body) throws ApiException {
        String operationId = "queryEventFilteredUsers";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        QueryEventFilteredUsersRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling queryEventFilteredUsers");
        }
        String localVarPath = "/api/v2/product-analytics/users/event_filtered_query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.queryEventFilteredUsers", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<QueryResponse>(){});
    }

    public CompletableFuture<ApiResponse<QueryResponse>> queryEventFilteredUsersWithHttpInfoAsync(QueryEventFilteredUsersRequest body) {
        Invocation.Builder builder;
        String operationId = "queryEventFilteredUsers";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        QueryEventFilteredUsersRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling queryEventFilteredUsers"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/users/event_filtered_query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.queryEventFilteredUsers", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<QueryResponse>(){});
    }

    public QueryResponse queryUsers(QueryUsersRequest body) throws ApiException {
        return this.queryUsersWithHttpInfo(body).getData();
    }

    public CompletableFuture<QueryResponse> queryUsersAsync(QueryUsersRequest body) {
        return this.queryUsersWithHttpInfoAsync(body).thenApply(response -> (QueryResponse)response.getData());
    }

    public ApiResponse<QueryResponse> queryUsersWithHttpInfo(QueryUsersRequest body) throws ApiException {
        String operationId = "queryUsers";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        QueryUsersRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling queryUsers");
        }
        String localVarPath = "/api/v2/product-analytics/users/query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.queryUsers", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<QueryResponse>(){});
    }

    public CompletableFuture<ApiResponse<QueryResponse>> queryUsersWithHttpInfoAsync(QueryUsersRequest body) {
        Invocation.Builder builder;
        String operationId = "queryUsers";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        QueryUsersRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling queryUsers"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/users/query";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.queryUsers", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<QueryResponse>> result = new CompletableFuture<ApiResponse<QueryResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<QueryResponse>(){});
    }

    public void updateConnection(String entity, UpdateConnectionRequest body) throws ApiException {
        this.updateConnectionWithHttpInfo(entity, body);
    }

    public CompletableFuture<Void> updateConnectionAsync(String entity, UpdateConnectionRequest body) {
        return this.updateConnectionWithHttpInfoAsync(entity, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> updateConnectionWithHttpInfo(String entity, UpdateConnectionRequest body) throws ApiException {
        String operationId = "updateConnection";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateConnectionRequest localVarPostBody = body;
        if (entity == null) {
            throw new ApiException(400, "Missing the required parameter 'entity' when calling updateConnection");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateConnection");
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connection".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.updateConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> updateConnectionWithHttpInfoAsync(String entity, UpdateConnectionRequest body) {
        Invocation.Builder builder;
        String operationId = "updateConnection";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateConnectionRequest localVarPostBody = body;
        if (entity == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'entity' when calling updateConnection"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateConnection"));
            return result;
        }
        String localVarPath = "/api/v2/product-analytics/{entity}/mapping/connection".replaceAll("\\{entity\\}", this.apiClient.escapeString(entity.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumAudienceManagementApi.updateConnection", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }
}

