/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateDeploymentGateParams;
import com.datadog.api.client.v2.model.CreateDeploymentRuleParams;
import com.datadog.api.client.v2.model.DeploymentGateResponse;
import com.datadog.api.client.v2.model.DeploymentRuleResponse;
import com.datadog.api.client.v2.model.UpdateDeploymentGateParams;
import com.datadog.api.client.v2.model.UpdateDeploymentRuleParams;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DeploymentGatesApi {
    private ApiClient apiClient;

    public DeploymentGatesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DeploymentGatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DeploymentGateResponse createDeploymentGate(CreateDeploymentGateParams body) throws ApiException {
        return this.createDeploymentGateWithHttpInfo(body).getData();
    }

    public CompletableFuture<DeploymentGateResponse> createDeploymentGateAsync(CreateDeploymentGateParams body) {
        return this.createDeploymentGateWithHttpInfoAsync(body).thenApply(response -> (DeploymentGateResponse)response.getData());
    }

    public ApiResponse<DeploymentGateResponse> createDeploymentGateWithHttpInfo(CreateDeploymentGateParams body) throws ApiException {
        String operationId = "createDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateDeploymentGateParams localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDeploymentGate");
        }
        String localVarPath = "/api/v2/deployment_gates";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.createDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentGateResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeploymentGateResponse>> createDeploymentGateWithHttpInfoAsync(CreateDeploymentGateParams body) {
        Invocation.Builder builder;
        String operationId = "createDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateDeploymentGateParams localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDeploymentGate"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.createDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentGateResponse>(){});
    }

    public DeploymentRuleResponse createDeploymentRule(String gateId, CreateDeploymentRuleParams body) throws ApiException {
        return this.createDeploymentRuleWithHttpInfo(gateId, body).getData();
    }

    public CompletableFuture<DeploymentRuleResponse> createDeploymentRuleAsync(String gateId, CreateDeploymentRuleParams body) {
        return this.createDeploymentRuleWithHttpInfoAsync(gateId, body).thenApply(response -> (DeploymentRuleResponse)response.getData());
    }

    public ApiResponse<DeploymentRuleResponse> createDeploymentRuleWithHttpInfo(String gateId, CreateDeploymentRuleParams body) throws ApiException {
        String operationId = "createDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateDeploymentRuleParams localVarPostBody = body;
        if (gateId == null) {
            throw new ApiException(400, "Missing the required parameter 'gateId' when calling createDeploymentRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDeploymentRule");
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.createDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeploymentRuleResponse>> createDeploymentRuleWithHttpInfoAsync(String gateId, CreateDeploymentRuleParams body) {
        Invocation.Builder builder;
        String operationId = "createDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateDeploymentRuleParams localVarPostBody = body;
        if (gateId == null) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'gateId' when calling createDeploymentRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDeploymentRule"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.createDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentRuleResponse>(){});
    }

    public void deleteDeploymentGate(String id) throws ApiException {
        this.deleteDeploymentGateWithHttpInfo(id);
    }

    public CompletableFuture<Void> deleteDeploymentGateAsync(String id) {
        return this.deleteDeploymentGateWithHttpInfoAsync(id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDeploymentGateWithHttpInfo(String id) throws ApiException {
        String operationId = "deleteDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteDeploymentGate");
        }
        String localVarPath = "/api/v2/deployment_gates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.deleteDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDeploymentGateWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        String operationId = "deleteDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteDeploymentGate"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.deleteDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteDeploymentRule(String gateId, String id) throws ApiException {
        this.deleteDeploymentRuleWithHttpInfo(gateId, id);
    }

    public CompletableFuture<Void> deleteDeploymentRuleAsync(String gateId, String id) {
        return this.deleteDeploymentRuleWithHttpInfoAsync(gateId, id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDeploymentRuleWithHttpInfo(String gateId, String id) throws ApiException {
        String operationId = "deleteDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (gateId == null) {
            throw new ApiException(400, "Missing the required parameter 'gateId' when calling deleteDeploymentRule");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteDeploymentRule");
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules/{id}".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.deleteDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDeploymentRuleWithHttpInfoAsync(String gateId, String id) {
        Invocation.Builder builder;
        String operationId = "deleteDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (gateId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'gateId' when calling deleteDeploymentRule"));
            return result;
        }
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteDeploymentRule"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules/{id}".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.deleteDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public DeploymentGateResponse getDeploymentGate(String id) throws ApiException {
        return this.getDeploymentGateWithHttpInfo(id).getData();
    }

    public CompletableFuture<DeploymentGateResponse> getDeploymentGateAsync(String id) {
        return this.getDeploymentGateWithHttpInfoAsync(id).thenApply(response -> (DeploymentGateResponse)response.getData());
    }

    public ApiResponse<DeploymentGateResponse> getDeploymentGateWithHttpInfo(String id) throws ApiException {
        String operationId = "getDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeploymentGate");
        }
        String localVarPath = "/api/v2/deployment_gates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.getDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentGateResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeploymentGateResponse>> getDeploymentGateWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        String operationId = "getDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getDeploymentGate"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.getDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentGateResponse>(){});
    }

    public DeploymentRuleResponse getDeploymentRule(String gateId, String id) throws ApiException {
        return this.getDeploymentRuleWithHttpInfo(gateId, id).getData();
    }

    public CompletableFuture<DeploymentRuleResponse> getDeploymentRuleAsync(String gateId, String id) {
        return this.getDeploymentRuleWithHttpInfoAsync(gateId, id).thenApply(response -> (DeploymentRuleResponse)response.getData());
    }

    public ApiResponse<DeploymentRuleResponse> getDeploymentRuleWithHttpInfo(String gateId, String id) throws ApiException {
        String operationId = "getDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (gateId == null) {
            throw new ApiException(400, "Missing the required parameter 'gateId' when calling getDeploymentRule");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDeploymentRule");
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules/{id}".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.getDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeploymentRuleResponse>> getDeploymentRuleWithHttpInfoAsync(String gateId, String id) {
        Invocation.Builder builder;
        String operationId = "getDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (gateId == null) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'gateId' when calling getDeploymentRule"));
            return result;
        }
        if (id == null) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getDeploymentRule"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules/{id}".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.getDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentRuleResponse>(){});
    }

    public DeploymentGateResponse updateDeploymentGate(String id, UpdateDeploymentGateParams body) throws ApiException {
        return this.updateDeploymentGateWithHttpInfo(id, body).getData();
    }

    public CompletableFuture<DeploymentGateResponse> updateDeploymentGateAsync(String id, UpdateDeploymentGateParams body) {
        return this.updateDeploymentGateWithHttpInfoAsync(id, body).thenApply(response -> (DeploymentGateResponse)response.getData());
    }

    public ApiResponse<DeploymentGateResponse> updateDeploymentGateWithHttpInfo(String id, UpdateDeploymentGateParams body) throws ApiException {
        String operationId = "updateDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateDeploymentGateParams localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateDeploymentGate");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDeploymentGate");
        }
        String localVarPath = "/api/v2/deployment_gates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.updateDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentGateResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeploymentGateResponse>> updateDeploymentGateWithHttpInfoAsync(String id, UpdateDeploymentGateParams body) {
        Invocation.Builder builder;
        String operationId = "updateDeploymentGate";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateDeploymentGateParams localVarPostBody = body;
        if (id == null) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling updateDeploymentGate"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDeploymentGate"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.updateDeploymentGate", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeploymentGateResponse>> result = new CompletableFuture<ApiResponse<DeploymentGateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentGateResponse>(){});
    }

    public DeploymentRuleResponse updateDeploymentRule(String gateId, String id, UpdateDeploymentRuleParams body) throws ApiException {
        return this.updateDeploymentRuleWithHttpInfo(gateId, id, body).getData();
    }

    public CompletableFuture<DeploymentRuleResponse> updateDeploymentRuleAsync(String gateId, String id, UpdateDeploymentRuleParams body) {
        return this.updateDeploymentRuleWithHttpInfoAsync(gateId, id, body).thenApply(response -> (DeploymentRuleResponse)response.getData());
    }

    public ApiResponse<DeploymentRuleResponse> updateDeploymentRuleWithHttpInfo(String gateId, String id, UpdateDeploymentRuleParams body) throws ApiException {
        String operationId = "updateDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateDeploymentRuleParams localVarPostBody = body;
        if (gateId == null) {
            throw new ApiException(400, "Missing the required parameter 'gateId' when calling updateDeploymentRule");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateDeploymentRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDeploymentRule");
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules/{id}".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.updateDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeploymentRuleResponse>> updateDeploymentRuleWithHttpInfoAsync(String gateId, String id, UpdateDeploymentRuleParams body) {
        Invocation.Builder builder;
        String operationId = "updateDeploymentRule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateDeploymentRuleParams localVarPostBody = body;
        if (gateId == null) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'gateId' when calling updateDeploymentRule"));
            return result;
        }
        if (id == null) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling updateDeploymentRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDeploymentRule"));
            return result;
        }
        String localVarPath = "/api/v2/deployment_gates/{gate_id}/rules/{id}".replaceAll("\\{gate_id\\}", this.apiClient.escapeString(gateId.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DeploymentGatesApi.updateDeploymentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeploymentRuleResponse>> result = new CompletableFuture<ApiResponse<DeploymentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeploymentRuleResponse>(){});
    }
}

