/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ConfigCatSDKKeyType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"api_password", "api_username", "sdk_key", "type"})
public class ConfigCatSDKKey {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_PASSWORD = "api_password";
    private String apiPassword;
    public static final String JSON_PROPERTY_API_USERNAME = "api_username";
    private String apiUsername;
    public static final String JSON_PROPERTY_SDK_KEY = "sdk_key";
    private String sdkKey;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ConfigCatSDKKeyType type;
    private Map<String, Object> additionalProperties;

    public ConfigCatSDKKey() {
    }

    @JsonCreator
    public ConfigCatSDKKey(@JsonProperty(required=true, value="api_password") String apiPassword, @JsonProperty(required=true, value="api_username") String apiUsername, @JsonProperty(required=true, value="sdk_key") String sdkKey, @JsonProperty(required=true, value="type") ConfigCatSDKKeyType type) {
        this.apiPassword = apiPassword;
        this.apiUsername = apiUsername;
        this.sdkKey = sdkKey;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ConfigCatSDKKey apiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
        return this;
    }

    @JsonProperty(value="api_password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiPassword() {
        return this.apiPassword;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    public ConfigCatSDKKey apiUsername(String apiUsername) {
        this.apiUsername = apiUsername;
        return this;
    }

    @JsonProperty(value="api_username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiUsername() {
        return this.apiUsername;
    }

    public void setApiUsername(String apiUsername) {
        this.apiUsername = apiUsername;
    }

    public ConfigCatSDKKey sdkKey(String sdkKey) {
        this.sdkKey = sdkKey;
        return this;
    }

    @JsonProperty(value="sdk_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSdkKey() {
        return this.sdkKey;
    }

    public void setSdkKey(String sdkKey) {
        this.sdkKey = sdkKey;
    }

    public ConfigCatSDKKey type(ConfigCatSDKKeyType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConfigCatSDKKeyType getType() {
        return this.type;
    }

    public void setType(ConfigCatSDKKeyType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public ConfigCatSDKKey putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigCatSDKKey configCatSdkKey = (ConfigCatSDKKey)o;
        return Objects.equals(this.apiPassword, configCatSdkKey.apiPassword) && Objects.equals(this.apiUsername, configCatSdkKey.apiUsername) && Objects.equals(this.sdkKey, configCatSdkKey.sdkKey) && Objects.equals(this.type, configCatSdkKey.type) && Objects.equals(this.additionalProperties, configCatSdkKey.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiPassword, this.apiUsername, this.sdkKey, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfigCatSDKKey {\n");
        sb.append("    apiPassword: ").append(this.toIndentedString(this.apiPassword)).append("\n");
        sb.append("    apiUsername: ").append(this.toIndentedString(this.apiUsername)).append("\n");
        sb.append("    sdkKey: ").append(this.toIndentedString(this.sdkKey)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

