/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.TeamConnection;
import com.datadog.api.client.v2.model.TeamConnectionCreateRequest;
import com.datadog.api.client.v2.model.TeamConnectionDeleteRequest;
import com.datadog.api.client.v2.model.TeamConnectionsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TeamConnectionsApi {
    private ApiClient apiClient;

    public TeamConnectionsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public TeamConnectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TeamConnectionsResponse createTeamConnections(TeamConnectionCreateRequest body) throws ApiException {
        return this.createTeamConnectionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<TeamConnectionsResponse> createTeamConnectionsAsync(TeamConnectionCreateRequest body) {
        return this.createTeamConnectionsWithHttpInfoAsync(body).thenApply(response -> (TeamConnectionsResponse)response.getData());
    }

    public ApiResponse<TeamConnectionsResponse> createTeamConnectionsWithHttpInfo(TeamConnectionCreateRequest body) throws ApiException {
        String operationId = "createTeamConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        TeamConnectionCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTeamConnections");
        }
        String localVarPath = "/api/v2/team/connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamConnectionsApi.createTeamConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamConnectionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamConnectionsResponse>> createTeamConnectionsWithHttpInfoAsync(TeamConnectionCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createTeamConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<TeamConnectionsResponse>> result = new CompletableFuture<ApiResponse<TeamConnectionsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        TeamConnectionCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<TeamConnectionsResponse>> result = new CompletableFuture<ApiResponse<TeamConnectionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createTeamConnections"));
            return result;
        }
        String localVarPath = "/api/v2/team/connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamConnectionsApi.createTeamConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamConnectionsResponse>> result = new CompletableFuture<ApiResponse<TeamConnectionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamConnectionsResponse>(){});
    }

    public void deleteTeamConnections(TeamConnectionDeleteRequest body) throws ApiException {
        this.deleteTeamConnectionsWithHttpInfo(body);
    }

    public CompletableFuture<Void> deleteTeamConnectionsAsync(TeamConnectionDeleteRequest body) {
        return this.deleteTeamConnectionsWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTeamConnectionsWithHttpInfo(TeamConnectionDeleteRequest body) throws ApiException {
        String operationId = "deleteTeamConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        TeamConnectionDeleteRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteTeamConnections");
        }
        String localVarPath = "/api/v2/team/connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamConnectionsApi.deleteTeamConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTeamConnectionsWithHttpInfoAsync(TeamConnectionDeleteRequest body) {
        Invocation.Builder builder;
        String operationId = "deleteTeamConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        TeamConnectionDeleteRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteTeamConnections"));
            return result;
        }
        String localVarPath = "/api/v2/team/connections";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.TeamConnectionsApi.deleteTeamConnections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public TeamConnectionsResponse listTeamConnections() throws ApiException {
        return this.listTeamConnectionsWithHttpInfo(new ListTeamConnectionsOptionalParameters()).getData();
    }

    public CompletableFuture<TeamConnectionsResponse> listTeamConnectionsAsync() {
        return this.listTeamConnectionsWithHttpInfoAsync(new ListTeamConnectionsOptionalParameters()).thenApply(response -> (TeamConnectionsResponse)response.getData());
    }

    public TeamConnectionsResponse listTeamConnections(ListTeamConnectionsOptionalParameters parameters) throws ApiException {
        return this.listTeamConnectionsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<TeamConnectionsResponse> listTeamConnectionsAsync(ListTeamConnectionsOptionalParameters parameters) {
        return this.listTeamConnectionsWithHttpInfoAsync(parameters).thenApply(response -> (TeamConnectionsResponse)response.getData());
    }

    public PaginationIterable<TeamConnection> listTeamConnectionsWithPagination() {
        ListTeamConnectionsOptionalParameters parameters = new ListTeamConnectionsOptionalParameters();
        return this.listTeamConnectionsWithPagination(parameters);
    }

    public PaginationIterable<TeamConnection> listTeamConnectionsWithPagination(ListTeamConnectionsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageNumber";
        Boolean valueSetterParamOptional = true;
        parameters.pageNumber(0L);
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<TeamConnection> iterator = new PaginationIterable<TeamConnection>(this, "listTeamConnections", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, false, limit, args);
        return iterator;
    }

    public ApiResponse<TeamConnectionsResponse> listTeamConnectionsWithHttpInfo(ListTeamConnectionsOptionalParameters parameters) throws ApiException {
        String operationId = "listTeamConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        List filterSources = parameters.filterSources;
        List filterTeamIds = parameters.filterTeamIds;
        List filterConnectedTeamIds = parameters.filterConnectedTeamIds;
        List filterConnectionIds = parameters.filterConnectionIds;
        String localVarPath = "/api/v2/team/connections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[sources]", filterSources));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[team_ids]", filterTeamIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[connected_team_ids]", filterConnectedTeamIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[connection_ids]", filterConnectionIds));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.TeamConnectionsApi.listTeamConnections", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamConnectionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<TeamConnectionsResponse>> listTeamConnectionsWithHttpInfoAsync(ListTeamConnectionsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listTeamConnections";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<TeamConnectionsResponse>> result = new CompletableFuture<ApiResponse<TeamConnectionsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        List filterSources = parameters.filterSources;
        List filterTeamIds = parameters.filterTeamIds;
        List filterConnectedTeamIds = parameters.filterConnectedTeamIds;
        List filterConnectionIds = parameters.filterConnectionIds;
        String localVarPath = "/api/v2/team/connections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[sources]", filterSources));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[team_ids]", filterTeamIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[connected_team_ids]", filterConnectedTeamIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[connection_ids]", filterConnectionIds));
        try {
            builder = this.apiClient.createBuilder("v2.TeamConnectionsApi.listTeamConnections", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamConnectionsResponse>> result = new CompletableFuture<ApiResponse<TeamConnectionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamConnectionsResponse>(){});
    }

    public static class ListTeamConnectionsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private List<String> filterSources;
        private List<String> filterTeamIds;
        private List<String> filterConnectedTeamIds;
        private List<String> filterConnectionIds;

        public ListTeamConnectionsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListTeamConnectionsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListTeamConnectionsOptionalParameters filterSources(List<String> filterSources) {
            this.filterSources = filterSources;
            return this;
        }

        public ListTeamConnectionsOptionalParameters filterTeamIds(List<String> filterTeamIds) {
            this.filterTeamIds = filterTeamIds;
            return this;
        }

        public ListTeamConnectionsOptionalParameters filterConnectedTeamIds(List<String> filterConnectedTeamIds) {
            this.filterConnectedTeamIds = filterConnectedTeamIds;
            return this;
        }

        public ListTeamConnectionsOptionalParameters filterConnectionIds(List<String> filterConnectionIds) {
            this.filterConnectionIds = filterConnectionIds;
            return this;
        }
    }
}

