/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.GetIssueIncludeQueryParameterItem;
import com.datadog.api.client.v2.model.IssueResponse;
import com.datadog.api.client.v2.model.IssueUpdateAssigneeRequest;
import com.datadog.api.client.v2.model.IssueUpdateStateRequest;
import com.datadog.api.client.v2.model.IssuesSearchRequest;
import com.datadog.api.client.v2.model.IssuesSearchResponse;
import com.datadog.api.client.v2.model.SearchIssuesIncludeQueryParameterItem;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ErrorTrackingApi {
    private ApiClient apiClient;

    public ErrorTrackingApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ErrorTrackingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteIssueAssignee(String issueId) throws ApiException {
        this.deleteIssueAssigneeWithHttpInfo(issueId);
    }

    public CompletableFuture<Void> deleteIssueAssigneeAsync(String issueId) {
        return this.deleteIssueAssigneeWithHttpInfoAsync(issueId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIssueAssigneeWithHttpInfo(String issueId) throws ApiException {
        Object localVarPostBody = null;
        if (issueId == null) {
            throw new ApiException(400, "Missing the required parameter 'issueId' when calling deleteIssueAssignee");
        }
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}/assignee".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.deleteIssueAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIssueAssigneeWithHttpInfoAsync(String issueId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (issueId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'issueId' when calling deleteIssueAssignee"));
            return result;
        }
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}/assignee".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.deleteIssueAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public IssueResponse getIssue(String issueId) throws ApiException {
        return this.getIssueWithHttpInfo(issueId, new GetIssueOptionalParameters()).getData();
    }

    public CompletableFuture<IssueResponse> getIssueAsync(String issueId) {
        return this.getIssueWithHttpInfoAsync(issueId, new GetIssueOptionalParameters()).thenApply(response -> (IssueResponse)response.getData());
    }

    public IssueResponse getIssue(String issueId, GetIssueOptionalParameters parameters) throws ApiException {
        return this.getIssueWithHttpInfo(issueId, parameters).getData();
    }

    public CompletableFuture<IssueResponse> getIssueAsync(String issueId, GetIssueOptionalParameters parameters) {
        return this.getIssueWithHttpInfoAsync(issueId, parameters).thenApply(response -> (IssueResponse)response.getData());
    }

    public ApiResponse<IssueResponse> getIssueWithHttpInfo(String issueId, GetIssueOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (issueId == null) {
            throw new ApiException(400, "Missing the required parameter 'issueId' when calling getIssue");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.getIssue", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssueResponse>(){});
    }

    public CompletableFuture<ApiResponse<IssueResponse>> getIssueWithHttpInfoAsync(String issueId, GetIssueOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (issueId == null) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'issueId' when calling getIssue"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.getIssue", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssueResponse>(){});
    }

    public IssuesSearchResponse searchIssues(IssuesSearchRequest body) throws ApiException {
        return this.searchIssuesWithHttpInfo(body, new SearchIssuesOptionalParameters()).getData();
    }

    public CompletableFuture<IssuesSearchResponse> searchIssuesAsync(IssuesSearchRequest body) {
        return this.searchIssuesWithHttpInfoAsync(body, new SearchIssuesOptionalParameters()).thenApply(response -> (IssuesSearchResponse)response.getData());
    }

    public IssuesSearchResponse searchIssues(IssuesSearchRequest body, SearchIssuesOptionalParameters parameters) throws ApiException {
        return this.searchIssuesWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<IssuesSearchResponse> searchIssuesAsync(IssuesSearchRequest body, SearchIssuesOptionalParameters parameters) {
        return this.searchIssuesWithHttpInfoAsync(body, parameters).thenApply(response -> (IssuesSearchResponse)response.getData());
    }

    public ApiResponse<IssuesSearchResponse> searchIssuesWithHttpInfo(IssuesSearchRequest body, SearchIssuesOptionalParameters parameters) throws ApiException {
        IssuesSearchRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling searchIssues");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/error-tracking/issues/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.searchIssues", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssuesSearchResponse>(){});
    }

    public CompletableFuture<ApiResponse<IssuesSearchResponse>> searchIssuesWithHttpInfoAsync(IssuesSearchRequest body, SearchIssuesOptionalParameters parameters) {
        Invocation.Builder builder;
        IssuesSearchRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IssuesSearchResponse>> result = new CompletableFuture<ApiResponse<IssuesSearchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling searchIssues"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/error-tracking/issues/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.searchIssues", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IssuesSearchResponse>> result = new CompletableFuture<ApiResponse<IssuesSearchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssuesSearchResponse>(){});
    }

    public IssueResponse updateIssueAssignee(String issueId, IssueUpdateAssigneeRequest body) throws ApiException {
        return this.updateIssueAssigneeWithHttpInfo(issueId, body).getData();
    }

    public CompletableFuture<IssueResponse> updateIssueAssigneeAsync(String issueId, IssueUpdateAssigneeRequest body) {
        return this.updateIssueAssigneeWithHttpInfoAsync(issueId, body).thenApply(response -> (IssueResponse)response.getData());
    }

    public ApiResponse<IssueResponse> updateIssueAssigneeWithHttpInfo(String issueId, IssueUpdateAssigneeRequest body) throws ApiException {
        IssueUpdateAssigneeRequest localVarPostBody = body;
        if (issueId == null) {
            throw new ApiException(400, "Missing the required parameter 'issueId' when calling updateIssueAssignee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIssueAssignee");
        }
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}/assignee".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.updateIssueAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssueResponse>(){});
    }

    public CompletableFuture<ApiResponse<IssueResponse>> updateIssueAssigneeWithHttpInfoAsync(String issueId, IssueUpdateAssigneeRequest body) {
        Invocation.Builder builder;
        IssueUpdateAssigneeRequest localVarPostBody = body;
        if (issueId == null) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'issueId' when calling updateIssueAssignee"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIssueAssignee"));
            return result;
        }
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}/assignee".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.updateIssueAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssueResponse>(){});
    }

    public IssueResponse updateIssueState(String issueId, IssueUpdateStateRequest body) throws ApiException {
        return this.updateIssueStateWithHttpInfo(issueId, body).getData();
    }

    public CompletableFuture<IssueResponse> updateIssueStateAsync(String issueId, IssueUpdateStateRequest body) {
        return this.updateIssueStateWithHttpInfoAsync(issueId, body).thenApply(response -> (IssueResponse)response.getData());
    }

    public ApiResponse<IssueResponse> updateIssueStateWithHttpInfo(String issueId, IssueUpdateStateRequest body) throws ApiException {
        IssueUpdateStateRequest localVarPostBody = body;
        if (issueId == null) {
            throw new ApiException(400, "Missing the required parameter 'issueId' when calling updateIssueState");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIssueState");
        }
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}/state".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.updateIssueState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssueResponse>(){});
    }

    public CompletableFuture<ApiResponse<IssueResponse>> updateIssueStateWithHttpInfoAsync(String issueId, IssueUpdateStateRequest body) {
        Invocation.Builder builder;
        IssueUpdateStateRequest localVarPostBody = body;
        if (issueId == null) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'issueId' when calling updateIssueState"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIssueState"));
            return result;
        }
        String localVarPath = "/api/v2/error-tracking/issues/{issue_id}/state".replaceAll("\\{issue_id\\}", this.apiClient.escapeString(issueId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ErrorTrackingApi.updateIssueState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IssueResponse>> result = new CompletableFuture<ApiResponse<IssueResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IssueResponse>(){});
    }

    public static class SearchIssuesOptionalParameters {
        private List<SearchIssuesIncludeQueryParameterItem> include;

        public SearchIssuesOptionalParameters include(List<SearchIssuesIncludeQueryParameterItem> include) {
            this.include = include;
            return this;
        }
    }

    public static class GetIssueOptionalParameters {
        private List<GetIssueIncludeQueryParameterItem> include;

        public GetIssueOptionalParameters include(List<GetIssueIncludeQueryParameterItem> include) {
            this.include = include;
            return this;
        }
    }
}

