/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.DORADeploymentRequest;
import com.datadog.api.client.v2.model.DORADeploymentResponse;
import com.datadog.api.client.v2.model.DORAFailureRequest;
import com.datadog.api.client.v2.model.DORAFailureResponse;
import com.datadog.api.client.v2.model.DORAFetchResponse;
import com.datadog.api.client.v2.model.DORAListDeploymentsRequest;
import com.datadog.api.client.v2.model.DORAListFailuresRequest;
import com.datadog.api.client.v2.model.DORAListResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DoraMetricsApi {
    private ApiClient apiClient;

    public DoraMetricsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DoraMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DORADeploymentResponse createDORADeployment(DORADeploymentRequest body) throws ApiException {
        return this.createDORADeploymentWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORADeploymentResponse> createDORADeploymentAsync(DORADeploymentRequest body) {
        return this.createDORADeploymentWithHttpInfoAsync(body).thenApply(response -> (DORADeploymentResponse)response.getData());
    }

    public ApiResponse<DORADeploymentResponse> createDORADeploymentWithHttpInfo(DORADeploymentRequest body) throws ApiException {
        DORADeploymentRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDORADeployment");
        }
        String localVarPath = "/api/v2/dora/deployment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORADeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORADeploymentResponse>> createDORADeploymentWithHttpInfoAsync(DORADeploymentRequest body) {
        Invocation.Builder builder;
        DORADeploymentRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDORADeployment"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORADeploymentResponse>(){});
    }

    public DORAFailureResponse createDORAFailure(DORAFailureRequest body) throws ApiException {
        return this.createDORAFailureWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORAFailureResponse> createDORAFailureAsync(DORAFailureRequest body) {
        return this.createDORAFailureWithHttpInfoAsync(body).thenApply(response -> (DORAFailureResponse)response.getData());
    }

    public ApiResponse<DORAFailureResponse> createDORAFailureWithHttpInfo(DORAFailureRequest body) throws ApiException {
        DORAFailureRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDORAFailure");
        }
        String localVarPath = "/api/v2/dora/failure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFailureResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAFailureResponse>> createDORAFailureWithHttpInfoAsync(DORAFailureRequest body) {
        Invocation.Builder builder;
        DORAFailureRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAFailureResponse>> result = new CompletableFuture<ApiResponse<DORAFailureResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDORAFailure"));
            return result;
        }
        String localVarPath = "/api/v2/dora/failure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAFailureResponse>> result = new CompletableFuture<ApiResponse<DORAFailureResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFailureResponse>(){});
    }

    @Deprecated
    public DORAFailureResponse createDORAIncident(DORAFailureRequest body) throws ApiException {
        return this.createDORAIncidentWithHttpInfo(body).getData();
    }

    @Deprecated
    public CompletableFuture<DORAFailureResponse> createDORAIncidentAsync(DORAFailureRequest body) {
        return this.createDORAIncidentWithHttpInfoAsync(body).thenApply(response -> (DORAFailureResponse)response.getData());
    }

    @Deprecated
    public ApiResponse<DORAFailureResponse> createDORAIncidentWithHttpInfo(DORAFailureRequest body) throws ApiException {
        DORAFailureRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDORAIncident");
        }
        String localVarPath = "/api/v2/dora/incident";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFailureResponse>(){});
    }

    @Deprecated
    public CompletableFuture<ApiResponse<DORAFailureResponse>> createDORAIncidentWithHttpInfoAsync(DORAFailureRequest body) {
        Invocation.Builder builder;
        DORAFailureRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAFailureResponse>> result = new CompletableFuture<ApiResponse<DORAFailureResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDORAIncident"));
            return result;
        }
        String localVarPath = "/api/v2/dora/incident";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAFailureResponse>> result = new CompletableFuture<ApiResponse<DORAFailureResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFailureResponse>(){});
    }

    public void deleteDORADeployment(String deploymentId) throws ApiException {
        this.deleteDORADeploymentWithHttpInfo(deploymentId);
    }

    public CompletableFuture<Void> deleteDORADeploymentAsync(String deploymentId) {
        return this.deleteDORADeploymentWithHttpInfoAsync(deploymentId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDORADeploymentWithHttpInfo(String deploymentId) throws ApiException {
        Object localVarPostBody = null;
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling deleteDORADeployment");
        }
        String localVarPath = "/api/v2/dora/deployment/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.deleteDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDORADeploymentWithHttpInfoAsync(String deploymentId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (deploymentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deploymentId' when calling deleteDORADeployment"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployment/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.deleteDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteDORAFailure(String failureId) throws ApiException {
        this.deleteDORAFailureWithHttpInfo(failureId);
    }

    public CompletableFuture<Void> deleteDORAFailureAsync(String failureId) {
        return this.deleteDORAFailureWithHttpInfoAsync(failureId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDORAFailureWithHttpInfo(String failureId) throws ApiException {
        Object localVarPostBody = null;
        if (failureId == null) {
            throw new ApiException(400, "Missing the required parameter 'failureId' when calling deleteDORAFailure");
        }
        String localVarPath = "/api/v2/dora/failure/{failure_id}".replaceAll("\\{failure_id\\}", this.apiClient.escapeString(failureId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.deleteDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDORAFailureWithHttpInfoAsync(String failureId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (failureId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'failureId' when calling deleteDORAFailure"));
            return result;
        }
        String localVarPath = "/api/v2/dora/failure/{failure_id}".replaceAll("\\{failure_id\\}", this.apiClient.escapeString(failureId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.deleteDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public DORAFetchResponse getDORADeployment(String deploymentId) throws ApiException {
        return this.getDORADeploymentWithHttpInfo(deploymentId).getData();
    }

    public CompletableFuture<DORAFetchResponse> getDORADeploymentAsync(String deploymentId) {
        return this.getDORADeploymentWithHttpInfoAsync(deploymentId).thenApply(response -> (DORAFetchResponse)response.getData());
    }

    public ApiResponse<DORAFetchResponse> getDORADeploymentWithHttpInfo(String deploymentId) throws ApiException {
        Object localVarPostBody = null;
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling getDORADeployment");
        }
        String localVarPath = "/api/v2/dora/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAFetchResponse>> getDORADeploymentWithHttpInfoAsync(String deploymentId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (deploymentId == null) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deploymentId' when calling getDORADeployment"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public DORAFetchResponse getDORAFailure(String failureId) throws ApiException {
        return this.getDORAFailureWithHttpInfo(failureId).getData();
    }

    public CompletableFuture<DORAFetchResponse> getDORAFailureAsync(String failureId) {
        return this.getDORAFailureWithHttpInfoAsync(failureId).thenApply(response -> (DORAFetchResponse)response.getData());
    }

    public ApiResponse<DORAFetchResponse> getDORAFailureWithHttpInfo(String failureId) throws ApiException {
        Object localVarPostBody = null;
        if (failureId == null) {
            throw new ApiException(400, "Missing the required parameter 'failureId' when calling getDORAFailure");
        }
        String localVarPath = "/api/v2/dora/failures/{failure_id}".replaceAll("\\{failure_id\\}", this.apiClient.escapeString(failureId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAFetchResponse>> getDORAFailureWithHttpInfoAsync(String failureId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (failureId == null) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'failureId' when calling getDORAFailure"));
            return result;
        }
        String localVarPath = "/api/v2/dora/failures/{failure_id}".replaceAll("\\{failure_id\\}", this.apiClient.escapeString(failureId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public DORAListResponse listDORADeployments(DORAListDeploymentsRequest body) throws ApiException {
        return this.listDORADeploymentsWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORAListResponse> listDORADeploymentsAsync(DORAListDeploymentsRequest body) {
        return this.listDORADeploymentsWithHttpInfoAsync(body).thenApply(response -> (DORAListResponse)response.getData());
    }

    public ApiResponse<DORAListResponse> listDORADeploymentsWithHttpInfo(DORAListDeploymentsRequest body) throws ApiException {
        DORAListDeploymentsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listDORADeployments");
        }
        String localVarPath = "/api/v2/dora/deployments";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORADeployments", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAListResponse>> listDORADeploymentsWithHttpInfoAsync(DORAListDeploymentsRequest body) {
        Invocation.Builder builder;
        DORAListDeploymentsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling listDORADeployments"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployments";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORADeployments", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }

    public DORAListResponse listDORAFailures(DORAListFailuresRequest body) throws ApiException {
        return this.listDORAFailuresWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORAListResponse> listDORAFailuresAsync(DORAListFailuresRequest body) {
        return this.listDORAFailuresWithHttpInfoAsync(body).thenApply(response -> (DORAListResponse)response.getData());
    }

    public ApiResponse<DORAListResponse> listDORAFailuresWithHttpInfo(DORAListFailuresRequest body) throws ApiException {
        DORAListFailuresRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listDORAFailures");
        }
        String localVarPath = "/api/v2/dora/failures";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORAFailures", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAListResponse>> listDORAFailuresWithHttpInfoAsync(DORAListFailuresRequest body) {
        Invocation.Builder builder;
        DORAListFailuresRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling listDORAFailures"));
            return result;
        }
        String localVarPath = "/api/v2/dora/failures";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORAFailures", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }
}

