/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.org.glassfish.hk2.utilities.general;

import com.datadoghq.jakarta.validation.MessageInterpolator;
import com.datadoghq.jakarta.validation.Path;
import com.datadoghq.jakarta.validation.TraversableResolver;
import com.datadoghq.jakarta.validation.Validation;
import com.datadoghq.jakarta.validation.Validator;
import com.datadoghq.jakarta.validation.ValidatorContext;
import com.datadoghq.jakarta.validation.ValidatorFactory;
import com.datadoghq.org.glassfish.hk2.utilities.general.internal.MessageInterpolatorImpl;
import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.validator.HibernateValidator;

public class ValidatorUtilities {
    private static final TraversableResolver TRAVERSABLE_RESOLVER = new TraversableResolver(){

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }
    };
    private static Validator validator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Validator initializeValidator() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HibernateValidator.class.getClassLoader());
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator((MessageInterpolator)new MessageInterpolatorImpl());
            Validator validator = validatorContext.traversableResolver(TRAVERSABLE_RESOLVER).getValidator();
            return validator;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static synchronized Validator getValidator() {
        if (validator == null) {
            validator = AccessController.doPrivileged(new PrivilegedAction<Validator>(){

                @Override
                public Validator run() {
                    return ValidatorUtilities.initializeValidator();
                }
            });
        }
        if (validator == null) {
            throw new IllegalStateException("Could not find a jakarta.validator");
        }
        return validator;
    }
}

