/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.org.apache.http.protocol;

import com.datadoghq.org.apache.http.HttpEntityEnclosingRequest;
import com.datadoghq.org.apache.http.HttpException;
import com.datadoghq.org.apache.http.HttpRequest;
import com.datadoghq.org.apache.http.HttpRequestInterceptor;
import com.datadoghq.org.apache.http.annotation.Contract;
import com.datadoghq.org.apache.http.annotation.ThreadingBehavior;
import com.datadoghq.org.apache.http.protocol.HttpContext;
import com.datadoghq.org.apache.http.protocol.HttpDateGenerator;
import com.datadoghq.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

