/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.scribejava.core.pkce;

import com.datadoghq.com.github.scribejava.core.base64.Base64;
import com.datadoghq.com.github.scribejava.core.pkce.PKCE;
import com.datadoghq.com.github.scribejava.core.pkce.PKCECodeChallengeMethod;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PKCEService {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final int numberOFOctets;

    public PKCEService(int numberOFOctets) {
        this.numberOFOctets = numberOFOctets;
    }

    public PKCEService() {
        this(32);
    }

    public static PKCEService defaultInstance() {
        return DefaultInstanceHolder.INSTANCE;
    }

    public PKCE generatePKCE() {
        byte[] bytes = new byte[this.numberOFOctets];
        RANDOM.nextBytes(bytes);
        return this.generatePKCE(bytes);
    }

    public PKCE generatePKCE(byte[] randomBytes) {
        String codeVerifier = Base64.encodeUrlWithoutPadding(randomBytes);
        PKCE pkce = new PKCE();
        pkce.setCodeVerifier(codeVerifier);
        try {
            pkce.setCodeChallenge(pkce.getCodeChallengeMethod().transform2CodeChallenge(codeVerifier));
        }
        catch (NoSuchAlgorithmException nsaE) {
            pkce.setCodeChallengeMethod(PKCECodeChallengeMethod.PLAIN);
            try {
                pkce.setCodeChallenge(PKCECodeChallengeMethod.PLAIN.transform2CodeChallenge(codeVerifier));
            }
            catch (NoSuchAlgorithmException unrealE) {
                throw new IllegalStateException("It's just cannot be", unrealE);
            }
        }
        return pkce;
    }

    private static class DefaultInstanceHolder {
        private static final PKCEService INSTANCE = new PKCEService();

        private DefaultInstanceHolder() {
        }
    }
}

