/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RoutingRuleAction;
import com.datadog.api.client.v2.model.TimeRestrictions;
import com.datadog.api.client.v2.model.Urgency;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"actions", "query", "time_restriction", "urgency"})
public class RoutingRuleAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<RoutingRuleAction> actions = null;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_TIME_RESTRICTION = "time_restriction";
    private TimeRestrictions timeRestriction;
    public static final String JSON_PROPERTY_URGENCY = "urgency";
    private Urgency urgency;
    private Map<String, Object> additionalProperties;

    public RoutingRuleAttributes actions(List<RoutingRuleAction> actions) {
        this.actions = actions;
        for (RoutingRuleAction item : actions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public RoutingRuleAttributes addActionsItem(RoutingRuleAction actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<RoutingRuleAction>();
        }
        this.actions.add(actionsItem);
        this.unparsed |= actionsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RoutingRuleAction> getActions() {
        return this.actions;
    }

    public void setActions(List<RoutingRuleAction> actions) {
        this.actions = actions;
    }

    public RoutingRuleAttributes query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public RoutingRuleAttributes timeRestriction(TimeRestrictions timeRestriction) {
        this.timeRestriction = timeRestriction;
        this.unparsed |= timeRestriction.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time_restriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TimeRestrictions getTimeRestriction() {
        return this.timeRestriction;
    }

    public void setTimeRestriction(TimeRestrictions timeRestriction) {
        this.timeRestriction = timeRestriction;
    }

    public RoutingRuleAttributes urgency(Urgency urgency) {
        this.urgency = urgency;
        this.unparsed |= !urgency.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="urgency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Urgency getUrgency() {
        return this.urgency;
    }

    public void setUrgency(Urgency urgency) {
        if (!urgency.isValid()) {
            this.unparsed = true;
        }
        this.urgency = urgency;
    }

    @JsonAnySetter
    public RoutingRuleAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingRuleAttributes routingRuleAttributes = (RoutingRuleAttributes)o;
        return Objects.equals(this.actions, routingRuleAttributes.actions) && Objects.equals(this.query, routingRuleAttributes.query) && Objects.equals(this.timeRestriction, routingRuleAttributes.timeRestriction) && Objects.equals(this.urgency, routingRuleAttributes.urgency) && Objects.equals(this.additionalProperties, routingRuleAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.query, this.timeRestriction, this.urgency, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutingRuleAttributes {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    timeRestriction: ").append(this.toIndentedString(this.timeRestriction)).append("\n");
        sb.append("    urgency: ").append(this.toIndentedString(this.urgency)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

