/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RUMProductScales;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"application_id", "created_at", "created_by_handle", "hash", "is_active", "name", "org_id", "product_scales", "type", "updated_at", "updated_by_handle"})
public class RUMApplicationListAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_APPLICATION_ID = "application_id";
    private String applicationId;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATED_BY_HANDLE = "created_by_handle";
    private String createdByHandle;
    public static final String JSON_PROPERTY_HASH = "hash";
    private String hash;
    public static final String JSON_PROPERTY_IS_ACTIVE = "is_active";
    private Boolean isActive;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ORG_ID = "org_id";
    private Integer orgId;
    public static final String JSON_PROPERTY_PRODUCT_SCALES = "product_scales";
    private RUMProductScales productScales;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY_HANDLE = "updated_by_handle";
    private String updatedByHandle;
    private Map<String, Object> additionalProperties;

    public RUMApplicationListAttributes() {
    }

    @JsonCreator
    public RUMApplicationListAttributes(@JsonProperty(required=true, value="application_id") String applicationId, @JsonProperty(required=true, value="created_at") Long createdAt, @JsonProperty(required=true, value="created_by_handle") String createdByHandle, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="org_id") Integer orgId, @JsonProperty(required=true, value="type") String type, @JsonProperty(required=true, value="updated_at") Long updatedAt, @JsonProperty(required=true, value="updated_by_handle") String updatedByHandle) {
        this.applicationId = applicationId;
        this.createdAt = createdAt;
        this.createdByHandle = createdByHandle;
        this.name = name;
        this.orgId = orgId;
        this.type = type;
        this.updatedAt = updatedAt;
        this.updatedByHandle = updatedByHandle;
    }

    public RUMApplicationListAttributes applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @JsonProperty(value="application_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public RUMApplicationListAttributes createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public RUMApplicationListAttributes createdByHandle(String createdByHandle) {
        this.createdByHandle = createdByHandle;
        return this;
    }

    @JsonProperty(value="created_by_handle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCreatedByHandle() {
        return this.createdByHandle;
    }

    public void setCreatedByHandle(String createdByHandle) {
        this.createdByHandle = createdByHandle;
    }

    public RUMApplicationListAttributes hash(String hash) {
        this.hash = hash;
        return this;
    }

    @Nullable
    @JsonProperty(value="hash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public RUMApplicationListAttributes isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public RUMApplicationListAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RUMApplicationListAttributes orgId(Integer orgId) {
        this.orgId = orgId;
        return this;
    }

    @JsonProperty(value="org_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public RUMApplicationListAttributes productScales(RUMProductScales productScales) {
        this.productScales = productScales;
        this.unparsed |= productScales.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="product_scales")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMProductScales getProductScales() {
        return this.productScales;
    }

    public void setProductScales(RUMProductScales productScales) {
        this.productScales = productScales;
    }

    public RUMApplicationListAttributes type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public RUMApplicationListAttributes updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public RUMApplicationListAttributes updatedByHandle(String updatedByHandle) {
        this.updatedByHandle = updatedByHandle;
        return this;
    }

    @JsonProperty(value="updated_by_handle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUpdatedByHandle() {
        return this.updatedByHandle;
    }

    public void setUpdatedByHandle(String updatedByHandle) {
        this.updatedByHandle = updatedByHandle;
    }

    @JsonAnySetter
    public RUMApplicationListAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RUMApplicationListAttributes rumApplicationListAttributes = (RUMApplicationListAttributes)o;
        return Objects.equals(this.applicationId, rumApplicationListAttributes.applicationId) && Objects.equals(this.createdAt, rumApplicationListAttributes.createdAt) && Objects.equals(this.createdByHandle, rumApplicationListAttributes.createdByHandle) && Objects.equals(this.hash, rumApplicationListAttributes.hash) && Objects.equals(this.isActive, rumApplicationListAttributes.isActive) && Objects.equals(this.name, rumApplicationListAttributes.name) && Objects.equals(this.orgId, rumApplicationListAttributes.orgId) && Objects.equals(this.productScales, rumApplicationListAttributes.productScales) && Objects.equals(this.type, rumApplicationListAttributes.type) && Objects.equals(this.updatedAt, rumApplicationListAttributes.updatedAt) && Objects.equals(this.updatedByHandle, rumApplicationListAttributes.updatedByHandle) && Objects.equals(this.additionalProperties, rumApplicationListAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.createdAt, this.createdByHandle, this.hash, this.isActive, this.name, this.orgId, this.productScales, this.type, this.updatedAt, this.updatedByHandle, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RUMApplicationListAttributes {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdByHandle: ").append(this.toIndentedString(this.createdByHandle)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orgId: ").append(this.toIndentedString(this.orgId)).append("\n");
        sb.append("    productScales: ").append(this.toIndentedString(this.productScales)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedByHandle: ").append(this.toIndentedString(this.updatedByHandle)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

