/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.AbstractOpenApiSchema;
import com.datadog.api.client.JSON;
import com.datadog.api.client.UnparsedObject;
import com.datadog.api.client.v2.model.OpenAIAPIKeyUpdate;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.core.JsonGenerator;
import com.datadoghq.com.fasterxml.jackson.core.JsonParser;
import com.datadoghq.com.fasterxml.jackson.core.JsonProcessingException;
import com.datadoghq.com.fasterxml.jackson.core.JsonToken;
import com.datadoghq.com.fasterxml.jackson.core.type.TypeReference;
import com.datadoghq.com.fasterxml.jackson.databind.DeserializationContext;
import com.datadoghq.com.fasterxml.jackson.databind.JsonMappingException;
import com.datadoghq.com.fasterxml.jackson.databind.JsonNode;
import com.datadoghq.com.fasterxml.jackson.databind.MapperFeature;
import com.datadoghq.com.fasterxml.jackson.databind.ObjectMapper;
import com.datadoghq.com.fasterxml.jackson.databind.SerializerProvider;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.datadoghq.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.datadoghq.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=OpenAICredentialsUpdateDeserializer.class)
@JsonSerialize(using=OpenAICredentialsUpdateSerializer.class)
public class OpenAICredentialsUpdate
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(OpenAICredentialsUpdate.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public OpenAICredentialsUpdate() {
        super("oneOf", Boolean.FALSE);
    }

    public OpenAICredentialsUpdate(OpenAIAPIKeyUpdate o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(OpenAIAPIKeyUpdate.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be OpenAIAPIKeyUpdate");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public OpenAIAPIKeyUpdate getOpenAIAPIKeyUpdate() throws ClassCastException {
        return (OpenAIAPIKeyUpdate)super.getActualInstance();
    }

    static {
        schemas.put("OpenAIAPIKeyUpdate", new GenericType<OpenAIAPIKeyUpdate>(){});
        JSON.registerDescendants(OpenAICredentialsUpdate.class, Collections.unmodifiableMap(schemas));
    }

    public static class OpenAICredentialsUpdateDeserializer
    extends StdDeserializer<OpenAICredentialsUpdate> {
        public OpenAICredentialsUpdateDeserializer() {
            this(OpenAICredentialsUpdate.class);
        }

        public OpenAICredentialsUpdateDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public OpenAICredentialsUpdate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            OpenAIAPIKeyUpdate deserialized = null;
            OpenAIAPIKeyUpdate tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((OpenAIAPIKeyUpdate.class.equals(Integer.class) || OpenAIAPIKeyUpdate.class.equals(Long.class) || OpenAIAPIKeyUpdate.class.equals(Float.class) || OpenAIAPIKeyUpdate.class.equals(Double.class) || OpenAIAPIKeyUpdate.class.equals(Boolean.class) || OpenAIAPIKeyUpdate.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (OpenAIAPIKeyUpdate.class.equals(Integer.class) || OpenAIAPIKeyUpdate.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!OpenAIAPIKeyUpdate.class.equals(Float.class) && !OpenAIAPIKeyUpdate.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= OpenAIAPIKeyUpdate.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= OpenAIAPIKeyUpdate.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(OpenAIAPIKeyUpdate.class);
                    if (!tmp.unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'OpenAIAPIKeyUpdate'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'OpenAIAPIKeyUpdate'", e);
            }
            OpenAICredentialsUpdate ret = new OpenAICredentialsUpdate();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map<String, Object> res = new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), new TypeReference<Map<String, Object>>(){});
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        @Override
        public OpenAICredentialsUpdate getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "OpenAICredentialsUpdate cannot be null");
        }
    }

    public static class OpenAICredentialsUpdateSerializer
    extends StdSerializer<OpenAICredentialsUpdate> {
        public OpenAICredentialsUpdateSerializer(Class<OpenAICredentialsUpdate> t) {
            super(t);
        }

        public OpenAICredentialsUpdateSerializer() {
            this((Class<OpenAICredentialsUpdate>)null);
        }

        @Override
        public void serialize(OpenAICredentialsUpdate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

