/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LogsArchiveDestination;
import com.datadog.api.client.v2.model.LogsArchiveState;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"destination", "include_tags", "name", "query", "rehydration_max_scan_size_in_gb", "rehydration_tags", "state"})
public class LogsArchiveAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private LogsArchiveDestination destination;
    public static final String JSON_PROPERTY_INCLUDE_TAGS = "include_tags";
    private Boolean includeTags = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_REHYDRATION_MAX_SCAN_SIZE_IN_GB = "rehydration_max_scan_size_in_gb";
    private JsonNullable<Long> rehydrationMaxScanSizeInGb = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REHYDRATION_TAGS = "rehydration_tags";
    private List<String> rehydrationTags = null;
    public static final String JSON_PROPERTY_STATE = "state";
    private LogsArchiveState state;
    private Map<String, Object> additionalProperties;

    public LogsArchiveAttributes() {
    }

    @JsonCreator
    public LogsArchiveAttributes(@JsonProperty(required=true, value="destination") LogsArchiveDestination destination, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="query") String query) {
        this.destination = destination;
        if (destination != null) {
            this.unparsed |= destination.unparsed;
        }
        this.name = name;
        this.query = query;
    }

    public LogsArchiveAttributes destination(LogsArchiveDestination destination) {
        this.destination = destination;
        if (destination != null) {
            this.unparsed |= destination.unparsed;
        }
        return this;
    }

    @Nullable
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArchiveDestination getDestination() {
        return this.destination;
    }

    public void setDestination(LogsArchiveDestination destination) {
        this.destination = destination;
    }

    public LogsArchiveAttributes includeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @Nullable
    @JsonProperty(value="include_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public LogsArchiveAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsArchiveAttributes query(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsArchiveAttributes rehydrationMaxScanSizeInGb(Long rehydrationMaxScanSizeInGb) {
        this.rehydrationMaxScanSizeInGb = JsonNullable.of(rehydrationMaxScanSizeInGb);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getRehydrationMaxScanSizeInGb() {
        return this.rehydrationMaxScanSizeInGb.orElse(null);
    }

    @JsonProperty(value="rehydration_max_scan_size_in_gb")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getRehydrationMaxScanSizeInGb_JsonNullable() {
        return this.rehydrationMaxScanSizeInGb;
    }

    @JsonProperty(value="rehydration_max_scan_size_in_gb")
    public void setRehydrationMaxScanSizeInGb_JsonNullable(JsonNullable<Long> rehydrationMaxScanSizeInGb) {
        this.rehydrationMaxScanSizeInGb = rehydrationMaxScanSizeInGb;
    }

    public void setRehydrationMaxScanSizeInGb(Long rehydrationMaxScanSizeInGb) {
        this.rehydrationMaxScanSizeInGb = JsonNullable.of(rehydrationMaxScanSizeInGb);
    }

    public LogsArchiveAttributes rehydrationTags(List<String> rehydrationTags) {
        this.rehydrationTags = rehydrationTags;
        return this;
    }

    public LogsArchiveAttributes addRehydrationTagsItem(String rehydrationTagsItem) {
        if (this.rehydrationTags == null) {
            this.rehydrationTags = new ArrayList<String>();
        }
        this.rehydrationTags.add(rehydrationTagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="rehydration_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRehydrationTags() {
        return this.rehydrationTags;
    }

    public void setRehydrationTags(List<String> rehydrationTags) {
        this.rehydrationTags = rehydrationTags;
    }

    public LogsArchiveAttributes state(LogsArchiveState state) {
        this.state = state;
        this.unparsed |= !state.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsArchiveState getState() {
        return this.state;
    }

    public void setState(LogsArchiveState state) {
        if (!state.isValid()) {
            this.unparsed = true;
        }
        this.state = state;
    }

    @JsonAnySetter
    public LogsArchiveAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveAttributes logsArchiveAttributes = (LogsArchiveAttributes)o;
        return Objects.equals(this.destination, logsArchiveAttributes.destination) && Objects.equals(this.includeTags, logsArchiveAttributes.includeTags) && Objects.equals(this.name, logsArchiveAttributes.name) && Objects.equals(this.query, logsArchiveAttributes.query) && Objects.equals(this.rehydrationMaxScanSizeInGb, logsArchiveAttributes.rehydrationMaxScanSizeInGb) && Objects.equals(this.rehydrationTags, logsArchiveAttributes.rehydrationTags) && Objects.equals(this.state, logsArchiveAttributes.state) && Objects.equals(this.additionalProperties, logsArchiveAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.includeTags, this.name, this.query, this.rehydrationMaxScanSizeInGb, this.rehydrationTags, this.state, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveAttributes {\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    includeTags: ").append(this.toIndentedString(this.includeTags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    rehydrationMaxScanSizeInGb: ").append(this.toIndentedString(this.rehydrationMaxScanSizeInGb)).append("\n");
        sb.append("    rehydrationTags: ").append(this.toIndentedString(this.rehydrationTags)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

