/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IncidentTodoAttributes;
import com.datadog.api.client.v2.model.IncidentTodoRelationships;
import com.datadog.api.client.v2.model.IncidentTodoType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "id", "relationships", "type"})
public class IncidentTodoResponseData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IncidentTodoAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IncidentTodoRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentTodoType type = IncidentTodoType.INCIDENT_TODOS;
    private Map<String, Object> additionalProperties;

    public IncidentTodoResponseData() {
    }

    @JsonCreator
    public IncidentTodoResponseData(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") IncidentTodoType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public IncidentTodoResponseData attributes(IncidentTodoAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentTodoAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IncidentTodoAttributes attributes) {
        this.attributes = attributes;
    }

    public IncidentTodoResponseData id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IncidentTodoResponseData relationships(IncidentTodoRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentTodoRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IncidentTodoRelationships relationships) {
        this.relationships = relationships;
    }

    public IncidentTodoResponseData type(IncidentTodoType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentTodoType getType() {
        return this.type;
    }

    public void setType(IncidentTodoType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public IncidentTodoResponseData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentTodoResponseData incidentTodoResponseData = (IncidentTodoResponseData)o;
        return Objects.equals(this.attributes, incidentTodoResponseData.attributes) && Objects.equals(this.id, incidentTodoResponseData.id) && Objects.equals(this.relationships, incidentTodoResponseData.relationships) && Objects.equals(this.type, incidentTodoResponseData.type) && Objects.equals(this.additionalProperties, incidentTodoResponseData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.relationships, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentTodoResponseData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

