/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.GCPServiceAccountCredentialType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"private_key", "service_account_email", "type"})
public class GCPServiceAccountUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_PRIVATE_KEY = "private_key";
    private String privateKey;
    public static final String JSON_PROPERTY_SERVICE_ACCOUNT_EMAIL = "service_account_email";
    private String serviceAccountEmail;
    public static final String JSON_PROPERTY_TYPE = "type";
    private GCPServiceAccountCredentialType type;
    private Map<String, Object> additionalProperties;

    public GCPServiceAccountUpdate() {
    }

    @JsonCreator
    public GCPServiceAccountUpdate(@JsonProperty(required=true, value="type") GCPServiceAccountCredentialType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public GCPServiceAccountUpdate privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="private_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public GCPServiceAccountUpdate serviceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
        return this;
    }

    @Nullable
    @JsonProperty(value="service_account_email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServiceAccountEmail() {
        return this.serviceAccountEmail;
    }

    public void setServiceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
    }

    public GCPServiceAccountUpdate type(GCPServiceAccountCredentialType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GCPServiceAccountCredentialType getType() {
        return this.type;
    }

    public void setType(GCPServiceAccountCredentialType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public GCPServiceAccountUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCPServiceAccountUpdate gcpServiceAccountUpdate = (GCPServiceAccountUpdate)o;
        return Objects.equals(this.privateKey, gcpServiceAccountUpdate.privateKey) && Objects.equals(this.serviceAccountEmail, gcpServiceAccountUpdate.serviceAccountEmail) && Objects.equals(this.type, gcpServiceAccountUpdate.type) && Objects.equals(this.additionalProperties, gcpServiceAccountUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.serviceAccountEmail, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GCPServiceAccountUpdate {\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    serviceAccountEmail: ").append(this.toIndentedString(this.serviceAccountEmail)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

