/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.DataTransformProperties;
import com.datadog.api.client.v2.model.DataTransformType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "name", "properties", "type"})
public class DataTransform {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private DataTransformProperties properties;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DataTransformType type = DataTransformType.DATATRANSFORM;
    private Map<String, Object> additionalProperties;

    public DataTransform() {
    }

    @JsonCreator
    public DataTransform(@JsonProperty(required=true, value="id") UUID id, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="properties") DataTransformProperties properties, @JsonProperty(required=true, value="type") DataTransformType type) {
        this.id = id;
        this.name = name;
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public DataTransform id(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public DataTransform name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataTransform properties(DataTransformProperties properties) {
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        return this;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataTransformProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DataTransformProperties properties) {
        this.properties = properties;
    }

    public DataTransform type(DataTransformType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataTransformType getType() {
        return this.type;
    }

    public void setType(DataTransformType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public DataTransform putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTransform dataTransform = (DataTransform)o;
        return Objects.equals(this.id, dataTransform.id) && Objects.equals(this.name, dataTransform.name) && Objects.equals(this.properties, dataTransform.properties) && Objects.equals(this.type, dataTransform.type) && Objects.equals(this.additionalProperties, dataTransform.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.properties, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataTransform {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

