/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ContainerItem;
import com.datadog.api.client.v2.model.ContainerMeta;
import com.datadog.api.client.v2.model.ContainersResponseLinks;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "links", "meta"})
public class ContainersResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<ContainerItem> data = null;
    public static final String JSON_PROPERTY_LINKS = "links";
    private ContainersResponseLinks links;
    public static final String JSON_PROPERTY_META = "meta";
    private ContainerMeta meta;
    private Map<String, Object> additionalProperties;

    public ContainersResponse data(List<ContainerItem> data) {
        this.data = data;
        for (ContainerItem item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ContainersResponse addDataItem(ContainerItem dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<ContainerItem>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ContainerItem> getData() {
        return this.data;
    }

    public void setData(List<ContainerItem> data) {
        this.data = data;
    }

    public ContainersResponse links(ContainersResponseLinks links) {
        this.links = links;
        this.unparsed |= links.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContainersResponseLinks getLinks() {
        return this.links;
    }

    public void setLinks(ContainersResponseLinks links) {
        this.links = links;
    }

    public ContainersResponse meta(ContainerMeta meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContainerMeta getMeta() {
        return this.meta;
    }

    public void setMeta(ContainerMeta meta) {
        this.meta = meta;
    }

    @JsonAnySetter
    public ContainersResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainersResponse containersResponse = (ContainersResponse)o;
        return Objects.equals(this.data, containersResponse.data) && Objects.equals(this.links, containersResponse.links) && Objects.equals(this.meta, containersResponse.meta) && Objects.equals(this.additionalProperties, containersResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.links, this.meta, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainersResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

