/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AssetOperatingSystem;
import com.datadog.api.client.v2.model.AssetRisks;
import com.datadog.api.client.v2.model.AssetType;
import com.datadog.api.client.v2.model.AssetVersion;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"arch", "environments", "name", "operating_system", "risks", "teams", "type", "version"})
public class AssetAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ARCH = "arch";
    private String arch;
    public static final String JSON_PROPERTY_ENVIRONMENTS = "environments";
    private List<String> environments = new ArrayList<String>();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPERATING_SYSTEM = "operating_system";
    private AssetOperatingSystem operatingSystem;
    public static final String JSON_PROPERTY_RISKS = "risks";
    private AssetRisks risks;
    public static final String JSON_PROPERTY_TEAMS = "teams";
    private List<String> teams = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AssetType type;
    public static final String JSON_PROPERTY_VERSION = "version";
    private AssetVersion version;
    private Map<String, Object> additionalProperties;

    public AssetAttributes() {
    }

    @JsonCreator
    public AssetAttributes(@JsonProperty(required=true, value="environments") List<String> environments, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="risks") AssetRisks risks, @JsonProperty(required=true, value="type") AssetType type) {
        this.environments = environments;
        this.name = name;
        this.risks = risks;
        this.unparsed |= risks.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AssetAttributes arch(String arch) {
        this.arch = arch;
        return this;
    }

    @Nullable
    @JsonProperty(value="arch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public AssetAttributes environments(List<String> environments) {
        this.environments = environments;
        return this;
    }

    public AssetAttributes addEnvironmentsItem(String environmentsItem) {
        this.environments.add(environmentsItem);
        return this;
    }

    @JsonProperty(value="environments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<String> environments) {
        this.environments = environments;
    }

    public AssetAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AssetAttributes operatingSystem(AssetOperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
        this.unparsed |= operatingSystem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="operating_system")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetOperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(AssetOperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public AssetAttributes risks(AssetRisks risks) {
        this.risks = risks;
        this.unparsed |= risks.unparsed;
        return this;
    }

    @JsonProperty(value="risks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssetRisks getRisks() {
        return this.risks;
    }

    public void setRisks(AssetRisks risks) {
        this.risks = risks;
    }

    public AssetAttributes teams(List<String> teams) {
        this.teams = teams;
        return this;
    }

    public AssetAttributes addTeamsItem(String teamsItem) {
        if (this.teams == null) {
            this.teams = new ArrayList<String>();
        }
        this.teams.add(teamsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="teams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTeams() {
        return this.teams;
    }

    public void setTeams(List<String> teams) {
        this.teams = teams;
    }

    public AssetAttributes type(AssetType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssetType getType() {
        return this.type;
    }

    public void setType(AssetType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public AssetAttributes version(AssetVersion version) {
        this.version = version;
        this.unparsed |= version.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetVersion getVersion() {
        return this.version;
    }

    public void setVersion(AssetVersion version) {
        this.version = version;
    }

    @JsonAnySetter
    public AssetAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetAttributes assetAttributes = (AssetAttributes)o;
        return Objects.equals(this.arch, assetAttributes.arch) && Objects.equals(this.environments, assetAttributes.environments) && Objects.equals(this.name, assetAttributes.name) && Objects.equals(this.operatingSystem, assetAttributes.operatingSystem) && Objects.equals(this.risks, assetAttributes.risks) && Objects.equals(this.teams, assetAttributes.teams) && Objects.equals(this.type, assetAttributes.type) && Objects.equals(this.version, assetAttributes.version) && Objects.equals(this.additionalProperties, assetAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.arch, this.environments, this.name, this.operatingSystem, this.risks, this.teams, this.type, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetAttributes {\n");
        sb.append("    arch: ").append(this.toIndentedString(this.arch)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operatingSystem: ").append(this.toIndentedString(this.operatingSystem)).append("\n");
        sb.append("    risks: ").append(this.toIndentedString(this.risks)).append("\n");
        sb.append("    teams: ").append(this.toIndentedString(this.teams)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

