/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.SpansMetricCreateRequest;
import com.datadog.api.client.v2.model.SpansMetricResponse;
import com.datadog.api.client.v2.model.SpansMetricUpdateRequest;
import com.datadog.api.client.v2.model.SpansMetricsResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class SpansMetricsApi {
    private ApiClient apiClient;

    public SpansMetricsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SpansMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SpansMetricResponse createSpansMetric(SpansMetricCreateRequest body) throws ApiException {
        return this.createSpansMetricWithHttpInfo(body).getData();
    }

    public CompletableFuture<SpansMetricResponse> createSpansMetricAsync(SpansMetricCreateRequest body) {
        return this.createSpansMetricWithHttpInfoAsync(body).thenApply(response -> (SpansMetricResponse)response.getData());
    }

    public ApiResponse<SpansMetricResponse> createSpansMetricWithHttpInfo(SpansMetricCreateRequest body) throws ApiException {
        SpansMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSpansMetric");
        }
        String localVarPath = "/api/v2/apm/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansMetricsApi.createSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<SpansMetricResponse>> createSpansMetricWithHttpInfoAsync(SpansMetricCreateRequest body) {
        Invocation.Builder builder;
        SpansMetricCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SpansMetricResponse>> result = new CompletableFuture<ApiResponse<SpansMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSpansMetric"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpansMetricsApi.createSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SpansMetricResponse>> result = new CompletableFuture<ApiResponse<SpansMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricResponse>(){});
    }

    public void deleteSpansMetric(String metricId) throws ApiException {
        this.deleteSpansMetricWithHttpInfo(metricId);
    }

    public CompletableFuture<Void> deleteSpansMetricAsync(String metricId) {
        return this.deleteSpansMetricWithHttpInfoAsync(metricId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSpansMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling deleteSpansMetric");
        }
        String localVarPath = "/api/v2/apm/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansMetricsApi.deleteSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSpansMetricWithHttpInfoAsync(String metricId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling deleteSpansMetric"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpansMetricsApi.deleteSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SpansMetricResponse getSpansMetric(String metricId) throws ApiException {
        return this.getSpansMetricWithHttpInfo(metricId).getData();
    }

    public CompletableFuture<SpansMetricResponse> getSpansMetricAsync(String metricId) {
        return this.getSpansMetricWithHttpInfoAsync(metricId).thenApply(response -> (SpansMetricResponse)response.getData());
    }

    public ApiResponse<SpansMetricResponse> getSpansMetricWithHttpInfo(String metricId) throws ApiException {
        Object localVarPostBody = null;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling getSpansMetric");
        }
        String localVarPath = "/api/v2/apm/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansMetricsApi.getSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<SpansMetricResponse>> getSpansMetricWithHttpInfoAsync(String metricId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricId == null) {
            CompletableFuture<ApiResponse<SpansMetricResponse>> result = new CompletableFuture<ApiResponse<SpansMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling getSpansMetric"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpansMetricsApi.getSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SpansMetricResponse>> result = new CompletableFuture<ApiResponse<SpansMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricResponse>(){});
    }

    public SpansMetricsResponse listSpansMetrics() throws ApiException {
        return this.listSpansMetricsWithHttpInfo().getData();
    }

    public CompletableFuture<SpansMetricsResponse> listSpansMetricsAsync() {
        return this.listSpansMetricsWithHttpInfoAsync().thenApply(response -> (SpansMetricsResponse)response.getData());
    }

    public ApiResponse<SpansMetricsResponse> listSpansMetricsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/apm/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansMetricsApi.listSpansMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SpansMetricsResponse>> listSpansMetricsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/apm/config/metrics";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpansMetricsApi.listSpansMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SpansMetricsResponse>> result = new CompletableFuture<ApiResponse<SpansMetricsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricsResponse>(){});
    }

    public SpansMetricResponse updateSpansMetric(String metricId, SpansMetricUpdateRequest body) throws ApiException {
        return this.updateSpansMetricWithHttpInfo(metricId, body).getData();
    }

    public CompletableFuture<SpansMetricResponse> updateSpansMetricAsync(String metricId, SpansMetricUpdateRequest body) {
        return this.updateSpansMetricWithHttpInfoAsync(metricId, body).thenApply(response -> (SpansMetricResponse)response.getData());
    }

    public ApiResponse<SpansMetricResponse> updateSpansMetricWithHttpInfo(String metricId, SpansMetricUpdateRequest body) throws ApiException {
        SpansMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            throw new ApiException(400, "Missing the required parameter 'metricId' when calling updateSpansMetric");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSpansMetric");
        }
        String localVarPath = "/api/v2/apm/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpansMetricsApi.updateSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricResponse>(){});
    }

    public CompletableFuture<ApiResponse<SpansMetricResponse>> updateSpansMetricWithHttpInfoAsync(String metricId, SpansMetricUpdateRequest body) {
        Invocation.Builder builder;
        SpansMetricUpdateRequest localVarPostBody = body;
        if (metricId == null) {
            CompletableFuture<ApiResponse<SpansMetricResponse>> result = new CompletableFuture<ApiResponse<SpansMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricId' when calling updateSpansMetric"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SpansMetricResponse>> result = new CompletableFuture<ApiResponse<SpansMetricResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSpansMetric"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/metrics/{metric_id}".replaceAll("\\{metric_id\\}", this.apiClient.escapeString(metricId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpansMetricsApi.updateSpansMetric", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SpansMetricResponse>> result = new CompletableFuture<ApiResponse<SpansMetricResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SpansMetricResponse>(){});
    }
}

