/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ApplicationSecurityWafCustomRuleCreateRequest;
import com.datadog.api.client.v2.model.ApplicationSecurityWafCustomRuleListResponse;
import com.datadog.api.client.v2.model.ApplicationSecurityWafCustomRuleResponse;
import com.datadog.api.client.v2.model.ApplicationSecurityWafCustomRuleUpdateRequest;
import com.datadog.api.client.v2.model.ApplicationSecurityWafExclusionFilterCreateRequest;
import com.datadog.api.client.v2.model.ApplicationSecurityWafExclusionFilterResponse;
import com.datadog.api.client.v2.model.ApplicationSecurityWafExclusionFilterUpdateRequest;
import com.datadog.api.client.v2.model.ApplicationSecurityWafExclusionFiltersResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ApplicationSecurityApi {
    private ApiClient apiClient;

    public ApplicationSecurityApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ApplicationSecurityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApplicationSecurityWafCustomRuleResponse createApplicationSecurityWafCustomRule(ApplicationSecurityWafCustomRuleCreateRequest body) throws ApiException {
        return this.createApplicationSecurityWafCustomRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<ApplicationSecurityWafCustomRuleResponse> createApplicationSecurityWafCustomRuleAsync(ApplicationSecurityWafCustomRuleCreateRequest body) {
        return this.createApplicationSecurityWafCustomRuleWithHttpInfoAsync(body).thenApply(response -> (ApplicationSecurityWafCustomRuleResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafCustomRuleResponse> createApplicationSecurityWafCustomRuleWithHttpInfo(ApplicationSecurityWafCustomRuleCreateRequest body) throws ApiException {
        ApplicationSecurityWafCustomRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApplicationSecurityWafCustomRule");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.createApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> createApplicationSecurityWafCustomRuleWithHttpInfoAsync(ApplicationSecurityWafCustomRuleCreateRequest body) {
        Invocation.Builder builder;
        ApplicationSecurityWafCustomRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createApplicationSecurityWafCustomRule"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.createApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleResponse>(){});
    }

    public ApplicationSecurityWafExclusionFilterResponse createApplicationSecurityWafExclusionFilter(ApplicationSecurityWafExclusionFilterCreateRequest body) throws ApiException {
        return this.createApplicationSecurityWafExclusionFilterWithHttpInfo(body).getData();
    }

    public CompletableFuture<ApplicationSecurityWafExclusionFilterResponse> createApplicationSecurityWafExclusionFilterAsync(ApplicationSecurityWafExclusionFilterCreateRequest body) {
        return this.createApplicationSecurityWafExclusionFilterWithHttpInfoAsync(body).thenApply(response -> (ApplicationSecurityWafExclusionFilterResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafExclusionFilterResponse> createApplicationSecurityWafExclusionFilterWithHttpInfo(ApplicationSecurityWafExclusionFilterCreateRequest body) throws ApiException {
        ApplicationSecurityWafExclusionFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApplicationSecurityWafExclusionFilter");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.createApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> createApplicationSecurityWafExclusionFilterWithHttpInfoAsync(ApplicationSecurityWafExclusionFilterCreateRequest body) {
        Invocation.Builder builder;
        ApplicationSecurityWafExclusionFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createApplicationSecurityWafExclusionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.createApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFilterResponse>(){});
    }

    public void deleteApplicationSecurityWafCustomRule(String customRuleId) throws ApiException {
        this.deleteApplicationSecurityWafCustomRuleWithHttpInfo(customRuleId);
    }

    public CompletableFuture<Void> deleteApplicationSecurityWafCustomRuleAsync(String customRuleId) {
        return this.deleteApplicationSecurityWafCustomRuleWithHttpInfoAsync(customRuleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteApplicationSecurityWafCustomRuleWithHttpInfo(String customRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (customRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'customRuleId' when calling deleteApplicationSecurityWafCustomRule");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules/{custom_rule_id}".replaceAll("\\{custom_rule_id\\}", this.apiClient.escapeString(customRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.deleteApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteApplicationSecurityWafCustomRuleWithHttpInfoAsync(String customRuleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (customRuleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customRuleId' when calling deleteApplicationSecurityWafCustomRule"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules/{custom_rule_id}".replaceAll("\\{custom_rule_id\\}", this.apiClient.escapeString(customRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.deleteApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteApplicationSecurityWafExclusionFilter(String exclusionFilterId) throws ApiException {
        this.deleteApplicationSecurityWafExclusionFilterWithHttpInfo(exclusionFilterId);
    }

    public CompletableFuture<Void> deleteApplicationSecurityWafExclusionFilterAsync(String exclusionFilterId) {
        return this.deleteApplicationSecurityWafExclusionFilterWithHttpInfoAsync(exclusionFilterId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteApplicationSecurityWafExclusionFilterWithHttpInfo(String exclusionFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (exclusionFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'exclusionFilterId' when calling deleteApplicationSecurityWafExclusionFilter");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters/{exclusion_filter_id}".replaceAll("\\{exclusion_filter_id\\}", this.apiClient.escapeString(exclusionFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.deleteApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteApplicationSecurityWafExclusionFilterWithHttpInfoAsync(String exclusionFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (exclusionFilterId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'exclusionFilterId' when calling deleteApplicationSecurityWafExclusionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters/{exclusion_filter_id}".replaceAll("\\{exclusion_filter_id\\}", this.apiClient.escapeString(exclusionFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.deleteApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public ApplicationSecurityWafCustomRuleResponse getApplicationSecurityWafCustomRule(String customRuleId) throws ApiException {
        return this.getApplicationSecurityWafCustomRuleWithHttpInfo(customRuleId).getData();
    }

    public CompletableFuture<ApplicationSecurityWafCustomRuleResponse> getApplicationSecurityWafCustomRuleAsync(String customRuleId) {
        return this.getApplicationSecurityWafCustomRuleWithHttpInfoAsync(customRuleId).thenApply(response -> (ApplicationSecurityWafCustomRuleResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafCustomRuleResponse> getApplicationSecurityWafCustomRuleWithHttpInfo(String customRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (customRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'customRuleId' when calling getApplicationSecurityWafCustomRule");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules/{custom_rule_id}".replaceAll("\\{custom_rule_id\\}", this.apiClient.escapeString(customRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.getApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> getApplicationSecurityWafCustomRuleWithHttpInfoAsync(String customRuleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (customRuleId == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customRuleId' when calling getApplicationSecurityWafCustomRule"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules/{custom_rule_id}".replaceAll("\\{custom_rule_id\\}", this.apiClient.escapeString(customRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.getApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleResponse>(){});
    }

    public ApplicationSecurityWafExclusionFilterResponse getApplicationSecurityWafExclusionFilter(String exclusionFilterId) throws ApiException {
        return this.getApplicationSecurityWafExclusionFilterWithHttpInfo(exclusionFilterId).getData();
    }

    public CompletableFuture<ApplicationSecurityWafExclusionFilterResponse> getApplicationSecurityWafExclusionFilterAsync(String exclusionFilterId) {
        return this.getApplicationSecurityWafExclusionFilterWithHttpInfoAsync(exclusionFilterId).thenApply(response -> (ApplicationSecurityWafExclusionFilterResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafExclusionFilterResponse> getApplicationSecurityWafExclusionFilterWithHttpInfo(String exclusionFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (exclusionFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'exclusionFilterId' when calling getApplicationSecurityWafExclusionFilter");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters/{exclusion_filter_id}".replaceAll("\\{exclusion_filter_id\\}", this.apiClient.escapeString(exclusionFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.getApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> getApplicationSecurityWafExclusionFilterWithHttpInfoAsync(String exclusionFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (exclusionFilterId == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'exclusionFilterId' when calling getApplicationSecurityWafExclusionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters/{exclusion_filter_id}".replaceAll("\\{exclusion_filter_id\\}", this.apiClient.escapeString(exclusionFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.getApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFilterResponse>(){});
    }

    public ApplicationSecurityWafCustomRuleListResponse listApplicationSecurityWAFCustomRules() throws ApiException {
        return this.listApplicationSecurityWAFCustomRulesWithHttpInfo().getData();
    }

    public CompletableFuture<ApplicationSecurityWafCustomRuleListResponse> listApplicationSecurityWAFCustomRulesAsync() {
        return this.listApplicationSecurityWAFCustomRulesWithHttpInfoAsync().thenApply(response -> (ApplicationSecurityWafCustomRuleListResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafCustomRuleListResponse> listApplicationSecurityWAFCustomRulesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.listApplicationSecurityWAFCustomRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleListResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleListResponse>> listApplicationSecurityWAFCustomRulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.listApplicationSecurityWAFCustomRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleListResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleListResponse>(){});
    }

    public ApplicationSecurityWafExclusionFiltersResponse listApplicationSecurityWafExclusionFilters() throws ApiException {
        return this.listApplicationSecurityWafExclusionFiltersWithHttpInfo().getData();
    }

    public CompletableFuture<ApplicationSecurityWafExclusionFiltersResponse> listApplicationSecurityWafExclusionFiltersAsync() {
        return this.listApplicationSecurityWafExclusionFiltersWithHttpInfoAsync().thenApply(response -> (ApplicationSecurityWafExclusionFiltersResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafExclusionFiltersResponse> listApplicationSecurityWafExclusionFiltersWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.listApplicationSecurityWafExclusionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFiltersResponse>> listApplicationSecurityWafExclusionFiltersWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.listApplicationSecurityWafExclusionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFiltersResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFiltersResponse>(){});
    }

    public ApplicationSecurityWafCustomRuleResponse updateApplicationSecurityWafCustomRule(String customRuleId, ApplicationSecurityWafCustomRuleUpdateRequest body) throws ApiException {
        return this.updateApplicationSecurityWafCustomRuleWithHttpInfo(customRuleId, body).getData();
    }

    public CompletableFuture<ApplicationSecurityWafCustomRuleResponse> updateApplicationSecurityWafCustomRuleAsync(String customRuleId, ApplicationSecurityWafCustomRuleUpdateRequest body) {
        return this.updateApplicationSecurityWafCustomRuleWithHttpInfoAsync(customRuleId, body).thenApply(response -> (ApplicationSecurityWafCustomRuleResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafCustomRuleResponse> updateApplicationSecurityWafCustomRuleWithHttpInfo(String customRuleId, ApplicationSecurityWafCustomRuleUpdateRequest body) throws ApiException {
        ApplicationSecurityWafCustomRuleUpdateRequest localVarPostBody = body;
        if (customRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'customRuleId' when calling updateApplicationSecurityWafCustomRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationSecurityWafCustomRule");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules/{custom_rule_id}".replaceAll("\\{custom_rule_id\\}", this.apiClient.escapeString(customRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.updateApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> updateApplicationSecurityWafCustomRuleWithHttpInfoAsync(String customRuleId, ApplicationSecurityWafCustomRuleUpdateRequest body) {
        Invocation.Builder builder;
        ApplicationSecurityWafCustomRuleUpdateRequest localVarPostBody = body;
        if (customRuleId == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customRuleId' when calling updateApplicationSecurityWafCustomRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationSecurityWafCustomRule"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/custom_rules/{custom_rule_id}".replaceAll("\\{custom_rule_id\\}", this.apiClient.escapeString(customRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.updateApplicationSecurityWafCustomRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafCustomRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafCustomRuleResponse>(){});
    }

    public ApplicationSecurityWafExclusionFilterResponse updateApplicationSecurityWafExclusionFilter(String exclusionFilterId, ApplicationSecurityWafExclusionFilterUpdateRequest body) throws ApiException {
        return this.updateApplicationSecurityWafExclusionFilterWithHttpInfo(exclusionFilterId, body).getData();
    }

    public CompletableFuture<ApplicationSecurityWafExclusionFilterResponse> updateApplicationSecurityWafExclusionFilterAsync(String exclusionFilterId, ApplicationSecurityWafExclusionFilterUpdateRequest body) {
        return this.updateApplicationSecurityWafExclusionFilterWithHttpInfoAsync(exclusionFilterId, body).thenApply(response -> (ApplicationSecurityWafExclusionFilterResponse)response.getData());
    }

    public ApiResponse<ApplicationSecurityWafExclusionFilterResponse> updateApplicationSecurityWafExclusionFilterWithHttpInfo(String exclusionFilterId, ApplicationSecurityWafExclusionFilterUpdateRequest body) throws ApiException {
        ApplicationSecurityWafExclusionFilterUpdateRequest localVarPostBody = body;
        if (exclusionFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'exclusionFilterId' when calling updateApplicationSecurityWafExclusionFilter");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationSecurityWafExclusionFilter");
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters/{exclusion_filter_id}".replaceAll("\\{exclusion_filter_id\\}", this.apiClient.escapeString(exclusionFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.updateApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> updateApplicationSecurityWafExclusionFilterWithHttpInfoAsync(String exclusionFilterId, ApplicationSecurityWafExclusionFilterUpdateRequest body) {
        Invocation.Builder builder;
        ApplicationSecurityWafExclusionFilterUpdateRequest localVarPostBody = body;
        if (exclusionFilterId == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'exclusionFilterId' when calling updateApplicationSecurityWafExclusionFilter"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationSecurityWafExclusionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/asm/waf/exclusion_filters/{exclusion_filter_id}".replaceAll("\\{exclusion_filter_id\\}", this.apiClient.escapeString(exclusionFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApplicationSecurityApi.updateApplicationSecurityWafExclusionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>> result = new CompletableFuture<ApiResponse<ApplicationSecurityWafExclusionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationSecurityWafExclusionFilterResponse>(){});
    }
}

