/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SignalArchiveReason;
import com.datadog.api.client.v1.model.SignalTriageState;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"archiveComment", "archiveReason", "state", "version"})
public class SignalStateUpdateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ARCHIVE_COMMENT = "archiveComment";
    private String archiveComment;
    public static final String JSON_PROPERTY_ARCHIVE_REASON = "archiveReason";
    private SignalArchiveReason archiveReason;
    public static final String JSON_PROPERTY_STATE = "state";
    private SignalTriageState state;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    private Map<String, Object> additionalProperties;

    public SignalStateUpdateRequest() {
    }

    @JsonCreator
    public SignalStateUpdateRequest(@JsonProperty(required=true, value="state") SignalTriageState state) {
        this.state = state;
        this.unparsed |= !state.isValid();
    }

    public SignalStateUpdateRequest archiveComment(String archiveComment) {
        this.archiveComment = archiveComment;
        return this;
    }

    @Nullable
    @JsonProperty(value="archiveComment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchiveComment() {
        return this.archiveComment;
    }

    public void setArchiveComment(String archiveComment) {
        this.archiveComment = archiveComment;
    }

    public SignalStateUpdateRequest archiveReason(SignalArchiveReason archiveReason) {
        this.archiveReason = archiveReason;
        this.unparsed |= !archiveReason.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="archiveReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SignalArchiveReason getArchiveReason() {
        return this.archiveReason;
    }

    public void setArchiveReason(SignalArchiveReason archiveReason) {
        if (!archiveReason.isValid()) {
            this.unparsed = true;
        }
        this.archiveReason = archiveReason;
    }

    public SignalStateUpdateRequest state(SignalTriageState state) {
        this.state = state;
        this.unparsed |= !state.isValid();
        return this;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SignalTriageState getState() {
        return this.state;
    }

    public void setState(SignalTriageState state) {
        if (!state.isValid()) {
            this.unparsed = true;
        }
        this.state = state;
    }

    public SignalStateUpdateRequest version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @JsonAnySetter
    public SignalStateUpdateRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalStateUpdateRequest signalStateUpdateRequest = (SignalStateUpdateRequest)o;
        return Objects.equals(this.archiveComment, signalStateUpdateRequest.archiveComment) && Objects.equals(this.archiveReason, signalStateUpdateRequest.archiveReason) && Objects.equals(this.state, signalStateUpdateRequest.state) && Objects.equals(this.version, signalStateUpdateRequest.version) && Objects.equals(this.additionalProperties, signalStateUpdateRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.archiveComment, this.archiveReason, this.state, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalStateUpdateRequest {\n");
        sb.append("    archiveComment: ").append(this.toIndentedString(this.archiveComment)).append("\n");
        sb.append("    archiveReason: ").append(this.toIndentedString(this.archiveReason)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

