/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLODataSourceQueryDefinition;
import com.datadog.api.client.v1.model.SLOFormula;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"formulas", "queries"})
public class SLOTimeSliceQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<SLOFormula> formulas = new ArrayList<SLOFormula>();
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<SLODataSourceQueryDefinition> queries = new ArrayList<SLODataSourceQueryDefinition>();
    private Map<String, Object> additionalProperties;

    public SLOTimeSliceQuery() {
    }

    @JsonCreator
    public SLOTimeSliceQuery(@JsonProperty(required=true, value="formulas") List<SLOFormula> formulas, @JsonProperty(required=true, value="queries") List<SLODataSourceQueryDefinition> queries) {
        this.formulas = formulas;
        this.queries = queries;
    }

    public SLOTimeSliceQuery formulas(List<SLOFormula> formulas) {
        this.formulas = formulas;
        for (SLOFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOTimeSliceQuery addFormulasItem(SLOFormula formulasItem) {
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SLOFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<SLOFormula> formulas) {
        this.formulas = formulas;
    }

    public SLOTimeSliceQuery queries(List<SLODataSourceQueryDefinition> queries) {
        this.queries = queries;
        for (SLODataSourceQueryDefinition item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOTimeSliceQuery addQueriesItem(SLODataSourceQueryDefinition queriesItem) {
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SLODataSourceQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<SLODataSourceQueryDefinition> queries) {
        this.queries = queries;
    }

    @JsonAnySetter
    public SLOTimeSliceQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOTimeSliceQuery sloTimeSliceQuery = (SLOTimeSliceQuery)o;
        return Objects.equals(this.formulas, sloTimeSliceQuery.formulas) && Objects.equals(this.queries, sloTimeSliceQuery.queries) && Objects.equals(this.additionalProperties, sloTimeSliceQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.formulas, this.queries, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOTimeSliceQuery {\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

