/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsListRequestTime;
import com.datadog.api.client.v1.model.LogsSort;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"index", "limit", "query", "sort", "startAt", "time"})
public class LogsListRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_INDEX = "index";
    private String index;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Integer limit;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_SORT = "sort";
    private LogsSort sort;
    public static final String JSON_PROPERTY_START_AT = "startAt";
    private String startAt;
    public static final String JSON_PROPERTY_TIME = "time";
    private LogsListRequestTime time;
    private Map<String, Object> additionalProperties;

    public LogsListRequest() {
    }

    @JsonCreator
    public LogsListRequest(@JsonProperty(required=true, value="time") LogsListRequestTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
    }

    public LogsListRequest index(String index) {
        this.index = index;
        return this;
    }

    @Nullable
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public LogsListRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public LogsListRequest query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsListRequest sort(LogsSort sort) {
        this.sort = sort;
        this.unparsed |= !sort.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsSort getSort() {
        return this.sort;
    }

    public void setSort(LogsSort sort) {
        if (!sort.isValid()) {
            this.unparsed = true;
        }
        this.sort = sort;
    }

    public LogsListRequest startAt(String startAt) {
        this.startAt = startAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="startAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public LogsListRequest time(LogsListRequestTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsListRequestTime getTime() {
        return this.time;
    }

    public void setTime(LogsListRequestTime time) {
        this.time = time;
    }

    @JsonAnySetter
    public LogsListRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListRequest logsListRequest = (LogsListRequest)o;
        return Objects.equals(this.index, logsListRequest.index) && Objects.equals(this.limit, logsListRequest.limit) && Objects.equals(this.query, logsListRequest.query) && Objects.equals(this.sort, logsListRequest.sort) && Objects.equals(this.startAt, logsListRequest.startAt) && Objects.equals(this.time, logsListRequest.time) && Objects.equals(this.additionalProperties, logsListRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.limit, this.query, this.sort, this.startAt, this.time, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListRequest {\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

