/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.AlertGraphWidgetDefinitionType;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.datadog.api.client.v1.model.WidgetTime;
import com.datadog.api.client.v1.model.WidgetVizType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"alert_id", "time", "title", "title_align", "title_size", "type", "viz_type"})
public class AlertGraphWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALERT_ID = "alert_id";
    private String alertId;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AlertGraphWidgetDefinitionType type = AlertGraphWidgetDefinitionType.ALERT_GRAPH;
    public static final String JSON_PROPERTY_VIZ_TYPE = "viz_type";
    private WidgetVizType vizType;
    private Map<String, Object> additionalProperties;

    public AlertGraphWidgetDefinition() {
    }

    @JsonCreator
    public AlertGraphWidgetDefinition(@JsonProperty(required=true, value="alert_id") String alertId, @JsonProperty(required=true, value="type") AlertGraphWidgetDefinitionType type, @JsonProperty(required=true, value="viz_type") WidgetVizType vizType) {
        this.alertId = alertId;
        this.type = type;
        this.unparsed |= !type.isValid();
        this.vizType = vizType;
        this.unparsed |= !vizType.isValid();
    }

    public AlertGraphWidgetDefinition alertId(String alertId) {
        this.alertId = alertId;
        return this;
    }

    @JsonProperty(value="alert_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAlertId() {
        return this.alertId;
    }

    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    public AlertGraphWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public AlertGraphWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AlertGraphWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public AlertGraphWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public AlertGraphWidgetDefinition type(AlertGraphWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AlertGraphWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(AlertGraphWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public AlertGraphWidgetDefinition vizType(WidgetVizType vizType) {
        this.vizType = vizType;
        this.unparsed |= !vizType.isValid();
        return this;
    }

    @JsonProperty(value="viz_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetVizType getVizType() {
        return this.vizType;
    }

    public void setVizType(WidgetVizType vizType) {
        if (!vizType.isValid()) {
            this.unparsed = true;
        }
        this.vizType = vizType;
    }

    @JsonAnySetter
    public AlertGraphWidgetDefinition putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertGraphWidgetDefinition alertGraphWidgetDefinition = (AlertGraphWidgetDefinition)o;
        return Objects.equals(this.alertId, alertGraphWidgetDefinition.alertId) && Objects.equals(this.time, alertGraphWidgetDefinition.time) && Objects.equals(this.title, alertGraphWidgetDefinition.title) && Objects.equals(this.titleAlign, alertGraphWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, alertGraphWidgetDefinition.titleSize) && Objects.equals(this.type, alertGraphWidgetDefinition.type) && Objects.equals(this.vizType, alertGraphWidgetDefinition.vizType) && Objects.equals(this.additionalProperties, alertGraphWidgetDefinition.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.alertId, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.vizType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlertGraphWidgetDefinition {\n");
        sb.append("    alertId: ").append(this.toIndentedString(this.alertId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    vizType: ").append(this.toIndentedString(this.vizType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

